import paho.mqtt.client as mqtt
import json
import random
from datetime import datetime
from scripts.core.engine.subscriber import MONGODB_COLLECTION, insert_to_mongodb
from scripts.constants import MQTT_BROKER , MQTT_PORT,MQTT_TOPIC


# Create an MQTT client object
client = mqtt.Client()

# Connect to the MQTT broker
client.connect(MQTT_BROKER, MQTT_PORT)

# Get message from user and publish it
while True:
    message = input("Enter message to publish: ")
    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

    # Create payload with humidity, temperature, and windspeed values
    payload = {
        "humidity": random.randint(1,10),
        "temperature": random.randint(20,50),
        "windspeed": random.randint(5,100)
    }

    # Add payload to message
    message_with_payload = {
        "message": message,
        "timestamp": timestamp,
        "payload": payload
    }

    # Convert message to JSON string
    message_json = json.dumps(message_with_payload)

    # Publish message
    client.publish(MQTT_TOPIC, message_json)
    print(f"Published message: {message_json}")

    # Create document to insert into MongoDB
    document = {
        "message": message ,
        "timestamp": datetime.utcnow(),
        "payload": payload,
        "topic": MQTT_TOPIC
    }

    # Insert the document into MongoDB
    insert_to_mongodb(document, MONGODB_COLLECTION)
    print("Message inserted into MongoDB")