from dotenv import load_dotenv

load_dotenv()

import uvicorn
from fastapi import FastAPI

from scripts.config.app_config import Service
from scripts.service.minmax import router


app = FastAPI(title="Weather Report")
app.include_router(router)

if __name__ == "__main__":
    uvicorn.run("main:app", host=Service.host, port=Service.port)
