import logging

from fastapi.routing import APIRouter

from scripts.constants import APIEndpoints
from scripts.core.handlers.agg import StudentData
from scripts.core.schema.agg import Student
from scripts.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.student_base)
handler = StudentData()


@router.post(APIEndpoints.insert)
async def insert_item(request_data: Student):
    try:
        handler.insert_data(request_data)
        return DefaultResponse(message="Successfully inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="inserted Failed due to server error")

@router.get(APIEndpoints.aggregate)
async def aggregate_item(stud_id: int):
    try:
        data = handler.aggregate_data(stud_id)
        return DefaultResponse(message="Successfully found", status="success", data=data)
    except ValueError:
        return DefaultResponse(message="Due to value error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Failed due to server error")