
from datetime import datetime

from scripts.core.db.mongo.interns2023 import mongo_client
from scripts.core.db.mongo.interns2023.agg import StudentCollection
from scripts.core.schema.agg import Student


class StudentData:

    def __init__(self):
        self.student_col = StudentCollection(mongo_client=mongo_client)

    def insert_data(self, request_data: Student):
        try:
            d = {"stud_id": request_data.stud_id,
                 "stud_name": request_data.stud_name,
                 "dateofadmission": datetime.now(),
                 "status": request_data.status,
                 "city": request_data.city}

            self.student_col.insert_one(d)
        except Exception as e:
            print(e, "Error Detected in inserting")

    def aggregate_data(self, stud_id):
        try:
            pipeline = [
                {
                    "$match":

                        {
                            "stud_id": stud_id,
                        },
                },
                {
                    "$sort":
                        {
                            "stud_name": -1,
                        },
                },
                {
                    "$limit": 5
                },
                {
                    "$project":
                        {
                            "stud_name": "$stud_name",
                            "_id": 0,
                        }

                }
            ]

            data = self.student_col.aggregate(pipeline)
            list_ = []
            for i in data:
                list_.append(i)
            return list_
        except Exception as e:
            print(e)