
import json

from sqlalchemy.orm import sessionmaker

from scripts.core.db.database import engine, Base
from scripts.core.schema.med import User, PhoneNumber, Order, OrderItem

Session = sessionmaker(bind=engine)
session = Session()

# Load the data from the JSON file
with open('C:/Users/vidya.m/Desktop/sample.json', 'r') as f:
    data = json.load(f)

def med():
    for user_data in data:
     user = User(
        name=user_data['name'],
        age=user_data['age'],
        email=user_data['email'],
        street=user_data['address']['street'],
        city=user_data['address']['city'],
        state=user_data['address']['state'],
        zip=user_data['address']['zip'],
    )

    # Create PhoneNumber instances for each phone number in the JSON file
    for phone_data in user_data['phone_numbers']:
        phone = PhoneNumber(
            type=phone_data['type'],
            number=phone_data['number'],
            extension=phone_data.get('extension'),
        )
        user.phone_numbers.append(phone)

    # Create Order instances for each order in the JSON file
    for order_data in user_data['orders']:
        order = Order(
            date=order_data['date'],
        )

        # Create OrderItem instances for each item in the order
        for item_data in order_data['items']:
            item = OrderItem(
                item_id=item_data['id'],
                name=item_data['name'],
            price=item_data['price'],
            quantity=item_data['quantity'],
        )
        order.items.append(item)

    user.orders.append(order)

    session.add(user)
Base.metadata.create_all(engine)
session.commit()

