# schema
from sqlalchemy import Column, Integer, String, ForeignKey, Float, create_engine
from sqlalchemy.dialects.postgresql import JSONB
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import relationship

engine = create_engine('postgresql://interns:interns%40123@192.168.0.220:5432/internsb2')

Base = declarative_base()

class Medication(Base):
    __tablename__ = 'medication'

    id = Column(Integer, primary_key=True,autoincrement=True)
    category = Column(String)
    name = Column(String)
    strength = Column(String)
    dose = Column(String)
    route = Column(String)
    sig = Column(String)
    pill_count = Column(String)
    refills = Column(String)
    selected_user_info = Column(JSONB)

    @property
    def category(self):
        return self._category

    @category.setter
    def category(self, value):
        self._category = value.title()

class User(Base):
    __tablename__ = 'users'

    id = Column(Integer, primary_key=True)
    medication_id = Column(Integer, ForeignKey(Medication.id))
    name = Column(String)
    age = Column(Integer)
    email = Column(String)
    street = Column(String)
    city = Column(String)
    state = Column(String)
    zip = Column(String)
    phone_numbers = relationship("PhoneNumber", cascade="all, delete-orphan")
    orders = relationship("Order", cascade="all, delete-orphan")

class PhoneNumber(Base):
    __tablename__ = 'phone_numbers'

    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, ForeignKey(User.id))
    type = Column(String)
    number = Column(String)
    extension = Column(String)


class Order(Base):
    __tablename__ = 'orders'

    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, ForeignKey(User.id))
    date = Column(String)
    items = relationship("OrderItem", cascade="all, delete-orphan")


class OrderItem(Base):
    __tablename__ = 'order_items'

    id = Column(Integer, primary_key=True)
    order_id = Column(Integer, ForeignKey(Order.id))
    item_id = Column(Integer)
    name = Column(String)
    price = Column(Float)
    quantity = Column(Integer)

Base.metadata.create_all(engine)
