from scripts.core.db.database import session
from scripts.core.schema.med import User, PhoneNumber, Order, OrderItem
from scripts.service.med import data

for user_data in data:
    user = User(
        name=user_data.get('name'),
        age=user_data.get('age'),
        email=user_data.get('email')
    )

    # Create PhoneNumber instances for each phone number in the JSON file
    phone_numbers = user_data.get('phone_numbers')
    if phone_numbers:
        user.phone_numbers = [
            PhoneNumber(
                type=phone_data.get('type'),
                number=phone_data.get('number'),
                extension=phone_data.get('extension')
            )
            for phone_data in phone_numbers
        ]

    # Create Order instances for each order in the JSON file
    orders = user_data.get('orders')
    if orders:
        user.orders = [
            Order(
                date=order_data.get('date'),
                items=[
                    OrderItem(
                        item_id=item_data.get('id'),
                        name=item_data.get('name'),
                        price=item_data.get('price'),
                        quantity=item_data.get('quantity')
                    )
                    for item_data in order_data.get('items', [])
                ]
            )
            for order_data in orders
        ]

    # Add the user to the session
    session.add(user)

# Commit the session to save the changes
session.commit()
