import logging

from fastapi.routing import APIRouter

from scripts.constants import APIEndpoints
from scripts.core.handler.student import StudentData
from scripts.core.schema.responses import DefaultResponse
from scripts.core.schema.student import student

router = APIRouter(prefix=APIEndpoints.student_base)
handler = StudentData()


@router.delete(APIEndpoints.delete)
async def delete_one(stud_id: int):
    try:
        handler.delete_data(stud_id)
        return DefaultResponse(message="Successfully deleted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to ID Error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Deletion failed due to server error")


@router.put(APIEndpoints.update)
async def update_one(request_data:student):
    try:
        handler.update_data(request_data)
        return DefaultResponse(message="Successfully Updated", status="success")
    except ValueError:
        return DefaultResponse(message="Due to ID error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Updation Failed due to server error")


@router.get(APIEndpoints.find)
async def find_one(stud_id: int):
    try:
        data = handler.find_data(stud_id)
        return DefaultResponse(message="Successfully found", status="success",data=data)
    except ValueError:
        return DefaultResponse(message="Due to ID error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message=" Failed to find due to server error")

@router.post(APIEndpoints.insert)
async def insert_one(request_data: student):
    try:
       handler.insert_data(request_data)
       return DefaultResponse(message="Successfully inserted", status="success")
    except ValueError:
        return DefaultResponse(message="Due to ID error")
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message=" Failed to insert due to server error")

