from scripts.core.db.mongo.interns2023 import mongo_client
from scripts.core.db.mongo.interns2023.student import StudentCollection
from scripts.core.schema.student import student


class StudentData:

    def __init__(self):
        self.student_col = StudentCollection(mongo_client=mongo_client)

    def delete_data(self, stud_id):
        try:
            self.student_col.delete_one(query={"stud_id": stud_id})
        except ValueError:
            raise ValueError("ID")
        except Exception as e:
            print(e, "Error Detected in Deletion")

    def update_data(self, request_data: student):
        try:
            d = {"stud_id": request_data.stud_id,
                 "stud_name": request_data.stud_name,
                 "parent_name": request_data.parent_name,
                 "status": request_data.status,
                 "department": request_data.department}
            self.student_col.update_one(query={"stud_id": request_data.stud_id}, data=d)
        except Exception as e:
            print(e, "Error Detected in Updation")

    def find_data(self, stud_id):
        try:
            data = self.student_col.find_one(query={"stud_id": stud_id})
            return data
        except Exception as e:
            print(e, "Error Detected in Finding")

    def insert_data(self, request_data: student):
        try:
            d = {"stud_id": request_data.stud_id,
                 "stud_name": request_data.stud_name,
                 "parent_name": request_data.parent_name,
                 "status": request_data.status,
                 "department": request_data.department}
            self.student_col.insert_one(d)
        except Exception as e:
            print(e, "Error Detected in inserting")