import pandas as pd
import sqlalchemy
import matplotlib.pyplot as plt


def get_downtime_data():
    engine = sqlalchemy.create_engine('postgresql://ilensdev:ilens5432@192.168.0.220/downtime_db')
    query = 'SELECT start_time, end_time FROM downtime_log ORDER BY start_time'
    return pd.read_sql_query(query, engine)


def downtime_data(data, unit='hour'):
    if unit == 'minute':
        divisor = 60
    elif unit == 'hour':
        divisor = 3600
    else:
        raise ValueError('Invalid unit. Please enter "hour" or "minute".')

    data['downtime'] = (data['start_time'].shift(-1) - data['end_time']).dt.total_seconds() / divisor
    data.loc[data.index[-1], 'downtime'] = 0

    return data


def plot_downtime(data, unit='hour'):
    data['date'] = data['start_time'].dt.date

    downtime_per_day = data.groupby('date')['downtime'].sum()

    plot_title = f'Downtime by Day ({unit.capitalize()}s)'
    ylabel = unit.capitalize() + 's'
    downtime_per_day.plot(kind='bar', stacked=True, title=plot_title)

    plt.xlabel('Date')
    plt.ylabel(ylabel)
    plt.xticks(rotation=90)
    plt.show()


def main():
    data = get_downtime_data()
    data = downtime_data(data)
    plot_downtime(data)

    data_minute = downtime_data(data, unit='minute')
    plot_downtime(data_minute, unit='minute')


if __name__ == '__main__':
    main()
