from matplotlib import pyplot as plt
from sqlalchemy import MetaData
from scripts.core.db.database import session

metadata = MetaData()


class SqlUtility:
    @staticmethod
    def get_downtime_data() :
        try:
            query = 'SELECT start_time, end_time FROM downtime_log ORDER BY start_time',session

        except Exception as e:
            print(e, "Error")


    def downtime_data(data, unit='hour'):
        try:
            if unit == 'minute':
                divisor = 60
            elif unit == 'hour':
                divisor = 3600
            else:
                raise ValueError('Invalid unit. Please enter "hour" or "minute".')

            data['downtime'] = (data['start_time'].shift(-1) - data['end_time']).dt.total_seconds() / divisor
            data.loc[data.index[-1], 'downtime'] = 0

            return data

        except Exception as e:
            print(e, "Error")


    def plot_downtime(data, unit='hour'):
        try:
            data['date'] = data['start_time'].dt.date

            downtime_per_day = data.groupby('date')['downtime'].sum()

            plot_title = f'Downtime by Day ({unit.capitalize()}s)'
            ylabel = unit.capitalize() + 's'
            downtime_per_day.plot(kind='bar', stacked=True, title=plot_title)

            plt.xlabel('Date')
            plt.ylabel(ylabel)
            plt.xticks(rotation=90)
            plt.show()

        except Exception as e:
            print(e, "Error")