import logging

from fastapi import APIRouter

from scripts.constants import APIEndpoints
from scripts.core.handler.time import PostgresqlCollectRecords
from scripts.core.schema.responses import DefaultResponse

router = APIRouter(prefix=APIEndpoints.calculate)
handler = PostgresqlCollectRecords()


@router.post(APIEndpoints.calculate)
async def downtime():
    try:
        data = handler.get_downtime_data()
        return DefaultResponse(message="Successfully Calculated", status="success", data=data)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Fetching Failed due to server error")

@router.post(APIEndpoints.calculate)
async def downtime_data():
    try:
        data = handler.downtime_data()
        return DefaultResponse(message="Successfully Calculated", status="success", data=data)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Fetching Failed due to server error")

@router.post(APIEndpoints.calculate)
async def plot_downtime():
    try:
        data = handler.plot_downtime()
        return DefaultResponse(message="Successfully Calculated", status="success", data=data)
    except Exception as e:
        logging.exception(e)
        return DefaultResponse(message="Fetching Failed due to server error")