import calendar
from datetime import datetime, timedelta
from dateutil.relativedelta import relativedelta


class AlarmTimeUtility:
    @staticmethod
    def parse_relative_time_data(time_range):
        start_date = None
        end_date = None
        if time_range == "last_five_minutes":
            start_date = datetime.strptime((datetime.today() - timedelta(minutes=5)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(minutes=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_fifteen_minutes":
            start_date = datetime.strptime((datetime.today() - timedelta(minutes=15)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(minutes=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_thirty_minutes":
            start_date = datetime.strptime((datetime.today() - timedelta(minutes=30)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(minutes=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_one_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=1)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_three_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=3)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_six_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=6)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_eight_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=8)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_twelve_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=12)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "last_twenty_four_hours":
            start_date = datetime.strptime((datetime.today() - timedelta(hours=24)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(hours=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")

        elif time_range == "today":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "today_so_far":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_week":
            today_date = datetime.today()
            week_start_date = today_date + timedelta(days=-(datetime.today().weekday() + 1))
            week_end_date = week_start_date + timedelta(days=6)
            start_date = datetime.strptime(week_start_date.strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime(week_end_date.strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_week_so_far":
            today_date = datetime.today()
            week_start_date = today_date + timedelta(days=-(datetime.today().weekday() + 1))
            week_end_date = today_date
            start_date = datetime.strptime(week_start_date.strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime(week_end_date.strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_month":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-01 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            last_date = calendar.monthrange(datetime.today().year, datetime.today().month)[1]
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-%m-{last_date} 23:59:59.000000".format(last_date=last_date)),
                                           "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_month_so_far":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-01 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_year":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-01-01 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-12-31 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_year_so_far":
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-01-01 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d %H:%M:%S.%f"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "yesterday":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-1)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=-1)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "day_before_yesterday":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-2)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=-2)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "this_day_last_week":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-7)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=-7)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "previous_week":
            today_date = datetime.today() + timedelta(days=-7)
            week_start_date = today_date + timedelta(days=-(datetime.today().weekday() + 1))
            week_end_date = week_start_date + timedelta(days=6)
            start_date = datetime.strptime(week_start_date.strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime(week_end_date.strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "previous_month":
            previous_month = datetime.today().month - 1
            last_date = calendar.monthrange(datetime.today().year, previous_month)[1]
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-{month}-01 00:00:00.000000".format(month=previous_month)),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-{month}-{last_date} 23:59:59.000000".format(month=previous_month, last_date=last_date)),
                                           "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "previous_year":
            last_year = datetime.today().year - 1
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "{last_year}-01-01 00:00:00.000000".format(last_year=last_year)),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "{last_year}-12-31 23:59:59.000000".format(last_year=last_year)),
                                           "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_two_days":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-2)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_seven_days":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-7)).strftime("%Y-%m-%d 00:00:00.000000"),
                                           "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_thirty_days":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-30)).strftime(
                "%Y-%m-%d 00:00:00.000000"), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_ninety_days":
            start_date = datetime.strptime((datetime.today() + timedelta(days=-90)).strftime(
                "%Y-%m-%d 00:00:00.000000"), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_six_months":
            start_date = datetime.strptime((datetime.today() + relativedelta(months=-6)).strftime(
                "%Y-%m-%d 00:00:00.000000"), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime("%Y-%m-%d 23:59:59.000000"),
                                         "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_one_year":
            last_year = datetime.today().year - 1
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "{last_year}-%m-%d %H:%M:%S.%f".format(last_year=last_year)), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-%m-%d %H:%M:%S.%f"), "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_two_year":
            last_year = datetime.today().year - 2
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "{last_year}-%m-%d %H:%M:%S.%f".format(last_year=last_year)), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-%m-%d %H:%M:%S.%f"), "%Y-%m-%d %H:%M:%S.%f")
        elif time_range == "last_five_year":
            last_year = datetime.today().year - 5
            start_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "{last_year}-%m-%d %H:%M:%S.%f".format(last_year=last_year)), "%Y-%m-%d %H:%M:%S.%f")
            end_date = datetime.strptime((datetime.today() + timedelta(days=0)).strftime(
                "%Y-%m-%d %H:%M:%S.%f"), "%Y-%m-%d %H:%M:%S.%f")
        return start_date, end_date
