# ------------------------------start of import statements---------------------------------#
import traceback

from flask import Blueprint, request

from scripts.config import app_constants
from scripts.core.handler.things.thing_configuration_handler import ThingHandler
from scripts.logging.logger import logger
# from scripts.core.services.login.login import login_required
from scripts.utils.AESEnc import apply_encryption

# -------------------------------end of import statements-----------------------------------#


# ---------------------------------- Flask Blueprint ---------------------------------------#

thing_blueprint = Blueprint("thing", __name__)

# ---------------------------------- Flask Blueprint ---------------------------------------#


obj_thing = ThingHandler()  # creating object for thing handler


@thing_blueprint.route(app_constants.Endpoints.things_fetch_thing_details, methods=['POST'])
# @login_required
# @apply_encryption
def fetch_thing_details():
    """
    This is the service to fetch priority and it's info
    :return: property with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_thing.fetch_thing_details(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property"}


@thing_blueprint.route(app_constants.Endpoints.things_fetch_property_list_in_thing_category, methods=['POST'])
# @login_required
# @apply_encryption
def fetch_property_list_for_category_in_things():
    """
    This is the service to fetch property list from a category in a thing
    :return: property with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_thing.fetch_property_list(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property"}


@thing_blueprint.route(app_constants.Endpoints.things_save_thing, methods=['POST'])
# @login_required
# @apply_encryption
def create_thing():
    """
    This is the service to create thing in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_thing.save_thing(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property:" + str(e))
        return {"status": "failed", "message": "failed to create property"}


@thing_blueprint.route(app_constants.Endpoints.things_left_side_bar, methods=['POST'])
# @login_required
# @apply_encryption
def create_thing_left_side_bar():
    """
    This is the service to create property in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_thing.generate_left_side_bar_json(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property:" + str(e))
        return {"status": "failed", "message": "failed to create property"}


@thing_blueprint.route(app_constants.Endpoints.things_list_tag_category, methods=['POST'])
# @apply_encryption
def list_tag_category():
    """
    This is the service to list tag category in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_thing.list_tag_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property category details")
        return {"status": "failed", "message": str(e)}


@thing_blueprint.route(app_constants.Endpoints.things_fetch_tag_category, methods=['POST'])
# @apply_encryption
def fetch_tag_category():
    """
    This is the service to list tag category in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_thing.fetch_tag_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property category details")
        return {"status": "failed", "message": str(e)}


@thing_blueprint.route(app_constants.Endpoints.things_fetch_tags, methods=['POST'])
#@login_required
# @apply_encryption
def list_tags_for_thing_model():
    """
    This is the service to list property  in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_thing.list_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}