from flask import Flask

# THINGS STUDIO blueprints
from scripts.config import app_configuration
from scripts.config.app_configuration import secure_flag, http_flag
from scripts.core.services.things.property import property_blueprint

from scripts.core.services.things.property_category import property_category_blueprint
from scripts.core.services.things.property_group import property_group_blueprint
from scripts.core.services.things.property_type import property_type_blueprint
from scripts.core.services.things.thing_configuration import thing_blueprint
from scripts.core.services.pipeline.pipeline_services import flow_diagram_blueprint


# declaring app
app = Flask(__name__)
app.config['SECRET_KEY'] = app_configuration.SERVICE_SECRET_KEY
app.config['SESSION_COOKIE_SECURE'] = secure_flag
app.config['SESSION_COOKIE_HTTPONLY'] = http_flag


app.register_blueprint(property_blueprint)
app.register_blueprint(property_category_blueprint)
app.register_blueprint(property_group_blueprint)
app.register_blueprint(property_type_blueprint)
app.register_blueprint(thing_blueprint)
app.register_blueprint(flow_diagram_blueprint)


app.run(host=app_configuration.SERVICE_HOST, port=app_configuration.SERVICE_PORT, debug=False, threaded=True, use_reloader=False)


