from scripts.config import app_constants
from scripts.utils.mongo_utility import MongoConnect
from scripts.config.db_connection_obj import ConnectionObj

if ConnectionObj.mongo_connection_obj is None:
    ConnectionObj.mongo_connection_obj = MongoConnect()
my_col = app_constants.DBMapping.unique_id
metadata = app_constants.DBMapping.mongo_db_name


class GetNewId:
    @staticmethod
    def get_next_id(param1):
        my_doc = ConnectionObj.mongo_connection_obj.find_one(metadata, my_col, {"key": param1})
        if not my_doc:
            my_dict = {"key": param1, "id": "100"}
            ConnectionObj.mongo_connection_obj.database_insertion(metadata, my_col, my_dict)
            return my_dict['id']
        else:
            my_query = {"key": param1}
            my_doc = [ConnectionObj.mongo_connection_obj.find_one(metadata, my_col, my_query, {"_id": 0, "id": 1})]
            for each_document in my_doc:
                count_value = str(int(each_document['id']) + 1)
                new_values = {"$set": {"id": count_value}}
                ConnectionObj.mongo_connection_obj.update_one(metadata, my_col, my_query, new_values)
                return str(int(each_document['id']) + 1)
