"""
this utility will add the keys like 1.deleted_by
                                    2. deleted_at
                                    3.isdeleted
for record instead of deleting that record permanently from db
"""
import traceback
import datetime
from scripts.logging.logger import logger
from scripts.utils.mongo_utility import MongoConnect
from flask import request
from scripts.config import app_constants
from scripts.config.db_connection_obj import ConnectionObj

metadata = app_constants.DBMapping.mongo_db_name
db_name = metadata

user_role_collection = app_constants.MongoMetadata.user_role
user_collection = app_constants.MongoMetadata.user
industry_collection = app_constants.MongoMetadata.industry
work_group_collection = app_constants.MongoMetadata.work_group
alarm_priority_type_collection = app_constants.MongoMetadata.alarm_priority_type
alarm_configuration_collection = app_constants.MongoMetadata.alarm_configuration
anomaly_rule_collection = app_constants.MongoMetadata.anomaly_rule
anomaly_model_collection = app_constants.MongoMetadata.anomaly
device_group = app_constants.MongoMetadata.device_group
tag_group = app_constants.MongoMetadata.tag_group
manual_entry_meta_data = app_constants.MongoMetadata.manual_entry_meta_data
gateway = app_constants.MongoMetadata.gateway
flow_model = app_constants.MongoMetadata.flow_model
pipeline_info = app_constants.MongoMetadata.pipeline_info_collection

service_collection_map = {
    "user_role": user_role_collection,
    "user": user_collection,
    "industry": industry_collection,
    "user_group": work_group_collection,
    "alarm_priority_type": alarm_priority_type_collection,
    "alarm_configuration": alarm_configuration_collection,
    "anomaly_rule": anomaly_rule_collection,
    "anomaly_model": anomaly_model_collection,
    "device_group": device_group,
    "tag_group": tag_group,
    "manual_entry_meta_data": manual_entry_meta_data,
    "gateway": gateway,
    "flow_model": flow_model,
    "pipeline_info":pipeline_info
}


class DeleteUtil(object):
    def __init__(self):
        if ConnectionObj.mongo_connection_obj is None:
            ConnectionObj.mongo_connection_obj = MongoConnect()

    @staticmethod
    def delete_record(service_name, query):
        try:
            collection_name = service_collection_map[service_name]
            if "user_id" in request.cookies:
                user_id = request.cookies.get("user_id")
            else:
                return {"status": "failed",
                        "message": "User unauthorized"}
            set_json = {"isdeleted": "true",
                        "deleted_by": user_id,
                        "deleted_at": datetime.datetime.now().strftime("%d-%m-%Y %H:%M:%S")}
            # print(collection_name)
            ConnectionObj.mongo_connection_obj.update_one(db_name=db_name,
                                                          collection_name=collection_name,
                                                          query=query,
                                                          set_json=set_json, upsert=True)
            return {"status": "success", "message": service_name + " deleted successfully"}
        except Exception as e:
            logger.exception(str(e))
            traceback.print_exc()
            return {"status": "failed", "message": str(e)}
