# ------------------------------start of import statements---------------------------------#
import traceback

from flask import Blueprint, request

from scripts.core.handler.things.property_type_handler import PropertyTypeHandler
#from scripts.services.login.login import login_required
from scripts.utils.AESEnc import apply_encryption
from scripts.config import app_constants

from scripts.logging.logger import logger

# -------------------------------end of import statements-----------------------------------#


# ---------------------------------- Flask Blueprint ---------------------------------------#

property_type_blueprint = Blueprint("property_type", __name__)

# ---------------------------------- Flask Blueprint ---------------------------------------#


handler_obj = PropertyTypeHandler()  # creating object for property type handler


@property_type_blueprint.route(app_constants.Endpoints.things_fetch_property_type_details, methods=['POST'])
#@login_required
# @apply_encryption
def fetch_property_type():
    """
    This is the service to fetch priority type and it's info
    :return: property type with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = handler_obj.fetch_property_type(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property type details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property type"}


@property_type_blueprint.route(app_constants.Endpoints.things_save_property_type, methods=['POST'])
# @login_required
# @apply_encryption
def create_property_type():
    """
    This is the service to save property type in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = handler_obj.save_property_type(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property type:" + str(e))
        return {"status": "failed", "message": "failed to create property type`"}


@property_type_blueprint.route(app_constants.Endpoints.things_list_property_type, methods=['POST'])
# @login_required
# @apply_encryption
def list_property_type():
    """
    This is the service to list property type in the things studio
    :return: list of property types available
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = handler_obj.list_property_type(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property type details")
        return {"status": "failed", "message": str(e)}


@property_type_blueprint.route(app_constants.Endpoints.things_delete_property_type, methods=['POST'])
# @login_required
# @apply_encryption
def delete_property_type():
    """
    This is the service to delete property type in the things studio
    :return: list of property types available
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = handler_obj.delete_property_type(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property type details")
        return {"status": "failed", "message": str(e)}
