# ------------------------------start of import statements---------------------------------#
import traceback

from flask import Blueprint, request

from scripts.core.handler.things.property_group_handler import PropertyGroupHandler
#from scripts.services.login.login import login_required
from scripts.utils.AESEnc import apply_encryption
from scripts.config import app_constants

from scripts.logging.logger import logger

# -------------------------------end of import statements-----------------------------------#


# ---------------------------------- Flask Blueprint ---------------------------------------#

property_group_blueprint = Blueprint("property_group", __name__)

# ---------------------------------- Flask Blueprint ---------------------------------------#


obj_property = PropertyGroupHandler()  # creating object for property type handler


@property_group_blueprint.route(app_constants.Endpoints.things_fetch_property_group, methods=['POST'])
#@login_required
@apply_encryption
def fetch_property_group():
    """
    This is the service to fetch property group and it's info
    :return: property with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            # print(input_data)
            return_json = obj_property.fetch_property_group(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property"}


@property_group_blueprint.route(app_constants.Endpoints.things_save_property_group, methods=['POST'])
#@login_required
@apply_encryption
def create_property_group():
    """
    This is the service to save property group in the things studio portal
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.save_property_group(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property group:" + str(e))
        return {"status": "failed", "message": "failed to create property group"}


@property_group_blueprint.route(app_constants.Endpoints.things_list_property_group, methods=['POST'])
# @login_required
@apply_encryption
def list_property_group():
    """
    This is the service to list property group in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.list_property_group(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}


@property_group_blueprint.route(app_constants.Endpoints.things_delete_property_group, methods=['POST'])
# @login_required
@apply_encryption
def delete_property_group():
    """
    This is the service to delete property group in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.delete_property_group(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while deleting property group")
        return {"status": "failed", "message": str(e)}


@property_group_blueprint.route(app_constants.Endpoints.things_fetch_property_list, methods=['POST'])
# @login_required
@apply_encryption
def fetch_property_available():
    """
    This is the service to fetch 10 properties to display in the drop down based on the user search
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.fetch_properties(input_json=input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}


@property_group_blueprint.route(app_constants.Endpoints.things_fetch_property_group_list, methods=['POST'])
# @login_required
@apply_encryption
def fetch_property_groups_available():
    """
    This is the service to fetch property groups to display in the drop down based on the user search
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.fetch_properties(input_json=input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}
