# ------------------------------start of import statements---------------------------------#
import traceback

from flask import Blueprint, request

from scripts.core.handler.things.property_category_handler import PropertyCategoryHandler
#from scripts.services.login.login import login_required
# from scripts.utils.AESEnc import apply_encryption
from scripts.config import app_constants

from scripts.logging.logger import logger

# -------------------------------end of import statements-----------------------------------#


# ---------------------------------- Flask Blueprint ---------------------------------------#

property_category_blueprint = Blueprint("property_category", __name__)

# ---------------------------------- Flask Blueprint ---------------------------------------#


obj_property_category = PropertyCategoryHandler()  # creating object for property type handler


@property_category_blueprint.route(app_constants.Endpoints.things_fetch_property_category, methods=['POST'])
#@login_required
# @apply_encryption
def fetch_property_category():
    """
    This is the service to fetch property category and it's info
    :return: property with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property_category.fetch_property_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property category details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property category"}


@property_category_blueprint.route(app_constants.Endpoints.things_save_property_category, methods=['POST'])
#@login_required
# @apply_encryption
def create_property_category():
    """
    This is the service to create property category in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property_category.save_property_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property:" + str(e))
        return {"status": "failed", "message": "failed to create property"}


@property_category_blueprint.route(app_constants.Endpoints.things_list_property_category, methods=['POST'])
#@login_required
# @apply_encryption
def list_property_category():
    """
    This is the service to list property category in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_property_category.list_property_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property category details")
        return {"status": "failed", "message": str(e)}


@property_category_blueprint.route(app_constants.Endpoints.things_delete_property_category, methods=['POST'])
#@login_required
# @apply_encryption
def delete_property_category():
    """
    This is the service to delete property category in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property_category.delete_property_category(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}
