# ------------------------------start of import statements---------------------------------#
import traceback

from flask import Blueprint, request

from scripts.core.handler.things.property_handler import PropertyHandler
#from scripts.services.login.login import login_required
# from scripts.utils.AESEnc import apply_encryption
from scripts.config import app_constants
from scripts.logging.logger import logger

# -------------------------------end of import statements-----------------------------------#


# ---------------------------------- Flask Blueprint ---------------------------------------#

property_blueprint = Blueprint("property", __name__)

# ---------------------------------- Flask Blueprint ---------------------------------------#


obj_property = PropertyHandler()  # creating object for property type handler


@property_blueprint.route(app_constants.Endpoints.things_fetch_property, methods=['POST'])
# #@login_required
# @apply_encryption
def fetch_property():
    """
    This is the service to fetch priority and it's info
    :return: property with all it's details
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.fetch_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details:" + str(e))
        return {"status": "failed", "message": "failed to fetch property"}


@property_blueprint.route(app_constants.Endpoints.things_save_property, methods=['POST'])
#@login_required
# @apply_encryption
def create_property():
    """
    This is the service to create property in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.save_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while creating property:" + str(e))
        return {"status": "failed", "message": "failed to create property"}


@property_blueprint.route(app_constants.Endpoints.things_list_property, methods=['POST'])
#@login_required
# @apply_encryption
def list_property():
    """
    This is the service to list property  in the things studio
    :return: list of property available
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.list_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}


@property_blueprint.route(app_constants.Endpoints.things_delete_property, methods=['POST'])
#@login_required
# @apply_encryption
def delete_property():
    """
    This is the service to delete property in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_property.delete_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}


@property_blueprint.route(app_constants.Endpoints.things_fetch_property_type_list, methods=['POST'])
#@login_required
# @apply_encryption
def fetch_property_types_available():
    """
    This is the service to fetch all property types available in the things studio
    :return: Base64 encoded JSON with status success or failed
    """
    try:
        if request.method == 'POST':
            input_data = request.get_json()
            return_json = obj_property.fetch_property_types(input_json=input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}


@property_blueprint.route(app_constants.Endpoints.things_fetch_unit_list, methods=['POST'])
#@login_required
# @apply_encryption
def fetch_unit_list():
    """
    This is the service to fetch units from the units collection
    :return: list of units and it's ids'
    """
    try:
        if request.method == 'POST':
            input_data = request.data
            return_json = obj_property.delete_property(input_data)
            return return_json
    except Exception as e:
        traceback.print_exc()
        logger.exception("exception while fetching property details")
        return {"status": "failed", "message": str(e)}
