"""
Module for defining the constants
"""


class CommonConstants(object):
    ui = 'ui_datetime_format'
    utc = 'utc_datetime_format'
    nsc = 'no_special_chars_datetime_format'
    umtf = 'user_meta_time_format'
    __utc_datetime_format__ = '%Y-%m-%dT%H:%M:%SZ'
    __ui_datetime_format__ = '%Y-%m-%d %H:%M:%S'
    __no_special_chars_datetime_format__ = '%Y%m%d%H%M%S'
    __user_meta_time_format__ = "%d-%m-%Y %H:%M:%S"
    __user_meta_time_format_ws__ = "%d-%m-%Y %H:%M"


class DateTimeFormats:
    date_formats = {
        "dd/MM/yyyy": "%d/%m/%Y",
        "dd-MM-yyyy": "%d-%m-%Y",
        "yyyy/dd/MM": "%Y/%d/%m",
        "yyyy-dd-MM": "%Y-%d-%m",
        "yyyy/MM/dd": "%Y/%m/%d",
        "yyyy-MM-dd": "%Y-%m-%d",
        "MM/dd/yyyy": "%m/%d/%Y",
        "MM-dd-yyyy": "%m-%d-%Y",
        "dateMonth": "%d %b",
        "monthDate": "%b %d",
        "dateMonthYear": "%d %b, %Y",
        "yearDateMonth": "%Y, %d %b",
        "monthDateYear": "%b %d, %Y",
        "yearMonthDate": "%Y, %b %d"
    }
    time_formats = {
        "HH:mm:ss": "%H:%M:%S",

    }


class MongoMetadata:
    custom_node = "custom_node"
    job_list = "job_list"
    flow_constant = "flow_model_static_content"
    sld = "sld"
    tag = "tag"
    rules_block = "rules"
    pipeline_type = "pipeline_category"
    property_type = "property_type"
    property = "property"
    property_group = "property_group"
    property_category = "property_category"
    thing = "thing"
    user = "user"
    unit = "unit"
    batch = "batch"
    sensor = "sensor"
    client = "client"
    lookup = "lookup"
    header = "header"
    flow_model = "flow_model"
    gateway = "gateway"
    machine = "machine"
    timeslot = "timeslot"
    industry = "industry"
    parameter = "parameter"
    user_role = "user_role"
    unique_id = "unique_id"
    tag_group = "tag_group"
    sld_dummy = "sld_dummy"
    all_sites = "all_sites"
    user_group = "user_group"
    work_group = "work_group"
    rule_engine = "rule_engine"
    sms_gateway = "sms_gateway"
    static_data = "static_data"
    system_user = "system_user"
    device_type = "device_type"
    device_group = "device_group"
    site_network = "site_network"
    gateway_type = "gateway_type"
    device_model = "device_model"
    lookup_table = "lookup_table"
    metadata_db = "ilens_metadata"
    protocol_list = "protocol_list"
    email_gateway = "email_gateway"
    timeslot_tree = "timeslot"
    unit_converter = "unit_converter"
    static_content = "static_content"
    device_instance = "device_instance"
    licence_details = "licence_details"
    physical_device = "physical_device"
    aggregation_db = "ilens_aggregation"
    gateway_instance = "gateway_instance"
    protocol_category = "protocol_category"
    alarm_priority_type = "alarm_priority_type"
    alarm_configuration = "alarm_configuration"
    manual_entry_records = "manual_entry_records"
    multiplication_factor = "multiplication_factor"
    manual_entry_meta_data = "manual_entry_meta_data"
    manual_entry_records_metadata = "manual_entry_records_metadata"
    triggered_alarms = "triggered_alarms"
    anomaly = "anomaly"
    anomaly_rule = "anomaly_rule"
    scada_config = "scada_config"
    scada_folder_details = "scada_folder_details"
    svg_file_details = "svg_file_details"
    license = "license"
    vendor_details = "vendor_details"
    ilens_hmi_db = "ilens_hmi"
    mqtt = "mqtt"
    mqtt_user = "mqtt_user"
    alarm_note = "alarm_note"
    client_license = "client_license"
    captcha_status = "captcha_status"
    public_portal_static_content = "public_portal_static_content"
    audit_log = "audit_log"
    protocol_keys = "protocol_keys"
    printer = "printer"
    ai_model_coll = "ai_models"
    ai_models_db = "metastax_ai"
    # Channel pipeline builder
    channel_pp_cc = "channel_pp_cc"
    channel_pipeline = "channel_pipeline"
    channel_pp_device = "channel_pp_device"
    associate_pp_device = "associate_pp_device"
    mobile_user = "mobile_user"
    widget_db = "ilens_widget"
    dashboard = "dashboard"
    report = "report"
    widget_collection = "widget"

    # Pipeline builder
    pipeline_info_collection = "pipeline_info"
    pipeline_instance_info_collection = "pipeline_instance"
    component_category_collection = 'pipeline_category'


class DBMapping:
    units = "units"
    unit_conversion = "unit_conversion"
    unit_group = "unit_group"
    tags = "tags"
    unique_id = "unique_id"
    tag_groups = "tag_groups"
    user = "user"
    user_role = "user_role"
    shifts = "shifts"
    constants = "constants"
    site_conf = "site_conf"
    device_model = "device_model"
    thresholds = "thresholds"
    rule_engine = "elogbook_rule_engine"
    sms_gateway = "sms_gateway"
    access_group = "access_group"
    process_conf = "process_conf"
    email_gateway = "email_gateway"
    unit_converter = "unit_converter"
    mongo_db_name = "ilens_configuration"
    customer_projects = "customer_projects"
    customer_logos = "customer_logos"
    protocol_list = "protocol_list"
    multiplication_factor = "multiplication_factor"
    protocol_category = "protocol_category"
    audit_logs = "audit_logs"
    audit_entry = "audit_entry"
    audit_details = "audit_details"
    # Channel pipeline builder
    channel_pp_cc = "channel_pp_cc"
    channel_pipeline = "channel_pipeline"
    channel_pp_device = "channel_pp_device"
    associate_pp_device = "associate_pp_device"
    custom_node = "custom_node"
    pipeline_type = "pipeline_category"

    gateway_instance = "gateway_instance"
    physical_device = "physical_device"
    device_instance = "device_instance"
    header = "header"
    aggregation_db = "ilens_aggregation"
    static_data = "static_data"

    downtime_reasons = "downtime_reasons"
    printers = "printers"
    jobs = "jobs"
    job_list = "job_list"
    alarm_configuration = "alarm_configuration"
    rule_configuration = "rule_engine"
    rules_block = "rules"
    alarm_priority = "alarm_priority"
    ilens_events = "ilens_events"
    triggered_alarms = "triggered_alarms"
    alarm_note = "alarm_note"
    alarms = "alarms"
    # SCADA or HMI collections
    ilens_hmi_db = "ilens_hmi"
    scada_config = "scada_config"
    scada_folder_details = "scada_folder_details"
    svg_file_details = "svg_file_details"
    sld = "sld_new"
    sld_dummy = "sld_dummy"
    work_group = "work_group"
    industry = "industry"
    tag = "tag"
    tag_category = "tag_category"
    unit = "unit"

    # Embedded Apps
    customer_apps = "customer_apps"
    category_apps = "category_apps"

    # THINGS STUDIO collections
    property = "property"
    property_type = "property_type"
    property_category = "property_category"
    property_group = "property_group"
    thing = "thing"

    db_scheduled_rule = "ilens_schedule_rule"
    scheduled_metadata = "schedule_metadata"
    scheduled_jobs = "scheduled_jobs"

    live_tags = "live_tags"

    metastax_ai = "metastax_ai"
    ai_models = "ai_models"
    ai_rules = "ai_rules"

    lookup_table = "lookup_table"
    # ems_app
    EMS_app = "EMS_app"
    variant_pricing = "variant_pricing"
    maintainance = "maintainance"
    general_info = "general_info"
    headerContent = "headerContent"
    project_id = "project_id"
    transmission_loss = "transmission_loss"
    cost_during_bid = "cost_during_bid"
    cost_during_external_purchase = "cost_during_external_purchase"
    maintenance_unit = "maintenance_unit"
    maintenance_day = "maintenance_day"
    maintenance_startTime = "maintenance_startTime"
    maintenance_endTime = "maintenance_endTime"
    maintenance_duration = "maintenance_duration"
    variantPricing_unit = "variantPricing_unit"
    variantPricing_price = "variantPricing_price"
    variantPricing_startTime = "variantPricing_startTime"
    variantPricing_endTime = "variantPricing_endTime"
    variantPricing_duration = "variantPricing_duration"
    maintenance_schedule = "maintenance_schedule"
    maximum_capacity = "maximum_capacity"
    penality = "penality"
    production_planned_units = "production_planned_units"
    description = 'description'
    sidebar_data = 'sidebar_data'


class MongoEncryptionConstants:
    # mongo exception codes
    MONGO001 = "Server was unable to eestablish connection with MongoDB"
    MONGO002 = "Server faced a problem when inserting document(s) into MongoDB"
    MONGO003 = "Server faced a problem to find the document(s) with the given condition"
    MONGO004 = "Server faced a problem to delete the document(s) with the given condition"
    MONGO005 = "Server faced a problem to update the document(s) with the given condition and given data"
    MONGO006 = "Server faced a problem when aggregating the data"
    MONGO007 = "Server faced a problem when closing the connection with MongoDB"

    # mongo encryption keys
    key_encrypt_keys = "encrypt_keys"
    key_exclude_encryption = "exclude_encryption"
    product_encrypted = "product_encrypted"
    max_docs_per_batch = 5
    # cipher_key = "a985195aaa464e61"
    # Product based configurable constants
    cipher_key = {
        'k': '-----BEGIN RSA PRIVATE KEY-----\nMIIEowIBAAKCAQEArVED5cr+tMtFtVmXl2O0cvQbEgoYSIFd8yvkmm6z7'
             'XAdX6Eg\nYkKez0ydTl26KOdJ18A7Kn8etWGe8nTkSGheJl9rn/J+lE1zpo4Zg/T3wDnM8FM3\nyuM26vpIb+0oJmNc9'
             'DkFXo4WtxRFZDytdETg/YyI+eJYDRDrZSrlqAzIDpAdLpv9\nUhsMhYQ+2n3PcauLeJb0dKPVTc6kSvGCs3LZ0WyTbRnQ'
             'yJMCWnaxzpSIUcH7qaqO\nKC/fBCKsZmRjRNSmQ3gepz4VnQKyJCm7CJk+cQiQMQzrspRPvhmGouHZUM36KjsG\n6ylx2'
             'Bu6OYy/HbrdRkJKNlv3u6BBL6Pn/ZJZGQIDAQABAoIBABI8eMhESnYbm1RI\nW8S8YzeIO1Pz13hDku7cArcEKG72kcSm'
             '58knAN5HjbK59nVI1tJ6gc84JnNH1Qlm\nZsG+p49qkWC4S3zPxHg1MfaaPzpM6qUr4G4656OkV5xdTBDz+gshd9Dp6vZ'
             'zDdUc\n9FRMTg8nqx79461mRxpzP8xloaQ0NcKBzFK9e3g/4i72LwgNP3E6xmESiu7goqJ1\nGOAI2mJie3TTY1z8sf4u'
             'iSFLMaFrExkq4z4KkwS7qF2nOJxhv8H/g9TGPNWrnzAw\nyBHwINBoUaJwiOT51xxIDLgNQiNoIFuaMKVu2l+rWtoQWKG'
             'iOnw1ZhYxeJCXByXC\nQqpAfgECgYEAwpzSfyot3PAlxm9iVK5Zc6lRdBq7Jazt7t91U6zeY7C4xzNG1Tuf\ncSYK3qRwl'
             'Mw2uXl9auxyV41rziX9sZhtFUnm4jcGv9MHeaAaSSPSsvrtZDFBS7ky\nl2Ixk1078LTZCLMYmAKCAr2XLmShBPSVcuaL'
             'kDRX4rvw7scWmMb86wECgYEA4/yC\nEAjXlL0WlOYDJ3J//Pg4iBtIedHXmn30goNuCBBaoYygXapeytEmU2q5hybQTMTX'
             '\nVl/vIAFiu0TX81VQ7LDLJaber/7GEsIT3x+xm0jFvOxFYVhT5b0s0z1CQolnRFsA\ndIwQ5u5GkP65hyJUa3ZMh+L6Vi'
             'sSCTKpAco9ZhkCgYAKFZ5CwKjHvhn3AmaSBMbV\n23xBC/GOrjtWGXY288pCWDH7AIk3G3PTpSkDCHpc+4gKbGU3WTFDoC'
             'xp7kYLId7l\nL4MrTban0gOdJdK234hXhfEvM+4yQlKAzbHL9RTaEET+0mj/14FtKu3elZBSdWoZ\nHiE1Q8EaGqsNdHuT'
             'RxxsAQKBgQCqw7enyveusPL5FE/IfDrhgArX55ehp0uWrEE4\ngLkp0RYRawOzJKlbwMy0LnxIfwoGdmnUiIbTsjYBjs8'
             'xs/WpU8LVsOeba3lxE21O\n8q5VYWy61T4ia9ZrjgbFMl0u+TwgNwlgQolmb5Lrh9/vGAejdjhcj+ZyJFCeExQE\nAzd6'
             'AQKBgBhe+FwMhTus961jqEKXBXm0/OaOgzOdgl/asuC8oLU7cAVD7sS2LFcU\nu7ofIVIG6cRWRruajIuCdlIcLOedTE4'
             'YL5jAuRL1TyVvxMm0FsrkWPABFrHWhsZs\nTSzpiOFJkLJTVnT7hlW/+m0qrKiW0zrFza0JaFwP/lj+hRrYGkOl\n'
             '-----END RSA PRIVATE KEY-----'}
    encrypt_collection_dict = \
        {DBMapping.user: {key_encrypt_keys: ["*"],
                          key_exclude_encryption: ["_id", "user_id", "client_id", "deleted_by",
                                                   "created_by", "username", "isdeleted", "email"]},
         DBMapping.user_role: {key_encrypt_keys: ["*"],
                               key_exclude_encryption: ["_id", "user_role_id", "user_role_name",
                                                        "client_id", "isdeleted", "default"]}}


class Endpoints:
    base_url = "/ilens_config"

    # common APIS
    get_site_hierarchy = base_url + "/get_site_hierarchy"
    get_site_level_hierarchy = base_url + "/get_site_level_hierarchy"
    fetch_tags = base_url + "/fetch_tags"
    get_activtiy_data = base_url + "/get_activity_data"
    get_users_list = base_url + "/get_users_list"
    # ems
    ems_request = base_url + "/request_ems_config"
    ems_table_data = base_url + "/list_ems_config"
    ems_general_info = base_url + "/save_general"
    # audit logs
    fetch_audit_data = base_url + "/fetch_audit_data"

    # project
    get_image = base_url + "/get_image"
    load_templates = base_url + "/load_templates"
    get_drop_down_data = "/get_drop_down_data"
    get_over_view = base_url + "/get_over_view"
    fetch_all_projects = base_url + "/get_all_projects"
    fetch_base_project = base_url + "/get_base_project"
    fetch_all_templates = base_url + "/get_all_templates"
    save_project = base_url + "/save_project"
    delete_project = base_url + "/delete_project"
    fetch_project_details = base_url + "/view_project"

    get_apps = base_url + "/get_apps"
    get_mqtt_details = base_url + "/get_mqtt_details"

    # license module
    update_licence = base_url + "/update_licence"

    save_custom_apps = base_url + "/save_embedded_apps"
    delete_custom_apps = base_url + "/delete_embedded_apps"
    list_custom_apps = base_url + "/list_embedded_apps"
    fetch_app_data = base_url + "/list_embedded_apps_based_on_id"
    starred_custom_apps = base_url + "/starred_embedded_apps"
    get_app_image = base_url + "/get_app_image"

    # site and process config
    save_site_config = base_url + "/save_site_configuration"
    list_site_config = base_url + "/list_site_configuration"
    list_site_hierarchy = base_url + "/list_site_hierarchy"
    delete_site_config = base_url + "/delete_site_configuration"
    fetch_dfm_data = base_url + "/fetch_dfm_data"
    site_list = base_url + "/site_list"
    save_process_config = base_url + "/save_process_configuration"
    step_icons = base_url + "/step_icons"
    list_process_config = base_url + "/list_process_configuration"
    process_list = base_url + "/process_list"
    delete_process_configuration = base_url + "/delete_process_configuration"
    get_stepper_json = base_url + "/get_stepper_json"
    fetch_dfm_data_process = base_url + "/fetch_dfm_data_process"
    get_e_template = base_url + "/get_e_template"
    fetch_stepper_json = base_url + "/fetch_stepper_json"

    # unit config
    list_unit_info = base_url + "/list_unit_info"
    save_units = base_url + "/save_units"
    save_unit_conversion = base_url + "/save_unit_conversion"
    save_unit_group = base_url + "/save_unit_group"
    delete_unit_data = base_url + "/delete_unit_data"
    get_unit_groups = base_url + "/get_unit_groups"
    get_units = base_url + "/get_units"

    # tag_config
    list_tags_info = base_url + "/list_tags_info"
    save_tags = base_url + "/save_tags"
    save_tag_groups = base_url + "/save_tag_groups"
    delete_tag_data = base_url + "/delete_tag_data"
    get_tag_types = base_url + "/get_tag_types"
    get_data_types = base_url + "/get_data_types"
    get_tag_group = base_url + "/get_tag_group"
    get_pincode_details = base_url + "/get_pincode_details"
    get_upload_tag_preview = base_url + "/get_tag_preview"
    get_upload_unit_preview = base_url + "/get_unit_preview"
    save_uploaded_tags = base_url + "/save_uploaded_tags"
    save_uploaded_units = base_url + "/save_uploaded_units"
    get_attributes_for_tag = base_url + "/fetch_attributes_for_tag"
    save_tag_category = base_url + "/save_tag_category"
    mark_job_as_read = base_url + "/mark_job_as_read"
    fetch_tag_category = base_url + "/fetch_tag_category"
    fetch_product_tags = base_url + "/fetch_product_tags"
    save_attributes_for_tag = base_url + "/save_attributes_for_tag"
    fetch_list_by_type = base_url + "/fetch_list_by_type"
    fetch_tags_for_tag_group = base_url + "/fetch_tags_for_tag_group"
    fetch_tags_group_metadata = base_url + "/fetch_tag_group_meta"
    fetch_attributes_by_tags = base_url + "/fetch_attributes_by_tags"
    save_tags_for_tag_group = base_url + "/save_tags_for_tag_group"
    fetch_tags_by_tag_group = base_url + "/fetch_tags_by_tag_group"

    # user config
    create_user = base_url + "/create_user"
    list_user_details = base_url + "/list_user_details"
    delete_user = base_url + "/delete_user"
    list_all_users = base_url + "/list_all_users"
    list_role_access_group = base_url + "/list_role_access_group"

    # access group endpoints
    create_access_group = base_url + "/create_access_group"
    delete_access_group = base_url + "/delete_access_group"
    list_access_group = base_url + "/list_access_group"
    list_access_items = base_url + "/list_access_items"

    # user roles
    list_user_roles = base_url + "/list_user_roles"
    create_user_roles = base_url + "/create_user_roles"
    delete_user_roles = base_url + "/delete_user_roles"
    user_access_items = base_url + "/user_access_items"
    get_user_access_list = base_url + "/get_user_access_list"
    get_user_type = base_url + "/get_user_type"
    list_timezone = base_url + "/list_timezone"
    save_timezone = base_url + "/save_timezone"
    fetch_timezone = base_url + "/fetch_timezone"

    # account
    list_profile_details = base_url + "/list_account_details"
    save_profile_details = base_url + "/save_profile_details"
    load_notification = base_url + "/load_notification"
    change_notification_status = base_url + "/change_notification_status"

    # login
    login = base_url + "/login"
    logout = base_url + "/logout"
    forgot_password = base_url + '/user/forgot_password'
    update_password = base_url + '/user/update_password'
    reset_password = base_url + '/user/reset_password'

    # shift config
    save_shift = base_url + "/save_shift"
    save_activity = base_url + "/save_activity"
    list_shifts = base_url + "/list_shifts"
    load_shift_details = base_url + "/load_shift_details"
    delete_activity = base_url + "/delete_activity"
    delete_shift = base_url + "/delete_shift"

    # elogbook rule
    save_rule = base_url + "/save_rule"
    delete_rule = base_url + "/delete_rule"
    get_rule_data = base_url + "/get_rule_data"
    list_rules = base_url + "/list_rules"

    # email and sms gateway
    create_email_gateway = base_url + '/create_email_gateway'
    list_email_gateway = base_url + "/list_email_gateway"
    delete_email_gateway = base_url + "/delete_email_gateway"
    email_gateway_system_default = base_url + "/email_gateway_system_default"
    test_email_response = base_url + "/test_email_response"
    create_sms_gateway = base_url + "/create_sms_gateway"
    list_sms_gateway = base_url + "/list_sms_gateway"
    delete_sms_gateway = base_url + "/delete_sms_gateway"
    sms_gateway_system_default = base_url + "/sms_gateway_system_default"
    test_sms_response = base_url + "/test_sms_gateway"

    # threshold
    create_threshold = base_url + "/create_threshold"
    delete_threshold = base_url + "/delete_threshold"
    get_threshold_data = base_url + "/get_threshold_data"
    list_thresholds = base_url + "/list_thresholds"

    # device model
    create_device_model = base_url + "/create_device_model"
    get_device_model = base_url + "/get_device_model"
    list_device_model = base_url + "/list_device_model"
    protocol_list = base_url + "/protocol_list"
    get_protocol_static_content = base_url + "/get_protocol_static_content"
    save_device_model = base_url + "/save_device_model"
    delete_device_model = base_url + "/delete_device_model"
    list_gateway_model = base_url + "/list_gateway_model"
    upload_csv = base_url + "/upload_csv"

    # Printer
    create_printer = base_url + "/create_printer"
    list_printer = base_url + "/list_printer"
    delete_printer = base_url + "/delete_printer"
    create_job_printer = base_url + "/create_job_printer"
    list_job_printer = base_url + "/list_job_printer"
    edit_printer = base_url + "/edit_printer"
    get_printer_static_content = base_url + "/get_printer_static_content"

    # downtime reasons
    save_downtime_reason = base_url + "/save_downtime_reason"
    delete_downtime_reason = base_url + "/delete_downtime_reason"
    list_downtime_reasons = base_url + "/list_downtime_reasons"

    # alarm configuration
    create_alarm_configuration = base_url + "/create_alarm_configuration"
    get_alarm_configuration = base_url + "/get_alarm_configuration"
    get_alarm_list = base_url + "/get_alarm_list"
    delete_alarm_configuration = base_url + "/delete_alarm_configuration"
    enable_disable_alarm = base_url + "/enable_disable_alarm"
    get_alarm_work_bench = base_url + "/get_alarm_work_bench"
    get_alarm_work_bench_updated = base_url + "/get_alarm_work_bench_updated"
    alarm_condition_fetch = base_url + "/alarm_condition_fetch"
    acknowledge_alarm = base_url + "/acknowledge_alarm"
    get_note = base_url + "/get_note"
    save_note = base_url + "/save_note"
    alarm_count = base_url + "/active_count"

    # rule configuration
    create_rule_configuration = base_url + "/rule_engine/create"
    delete_rule_configuration = base_url + "/rule_engine/delete"
    list_rule_configuration = base_url + "/rule_engine/get_list"
    lookup_metadata_rule_configuration = base_url + "/rule_engine/lookup_meta_data"
    fetch_tags_for_routing_rules = base_url + "/rule_engine/fetch_tags_for_routing"
    fetch_derived_tags = base_url + "/rule_engine/filter_data"
    fetch_rule_tags = base_url + "/rule_engine/get/tag_data"
    get_rule_hierarchy = base_url + "/rule_engine/get_site_hierarchy"

    # things

    things_fetch_property = '/things/fetch_property'
    things_save_property = '/things/save_property'
    things_list_property = '/things/list_property'
    things_delete_property = '/things/delete_property'
    things_fetch_property_type_list = '/things/config/fetch_property_type_list'
    things_fetch_unit_list = '/things/fetch_unit_list'

    things_fetch_property_category = '/things/fetch_property_category'
    things_save_property_category = '/things/save_property_category'
    things_list_property_category = '/things/list_tag_category'
    things_delete_property_category = '/things/delete_property_category'

    things_fetch_property_group = '/things/fetch_property_group'
    things_save_property_group = '/things/save_property_group'
    things_list_property_group = '/things/list_property_group'
    things_delete_property_group = '/things/delete_property_group'
    things_fetch_property_list = '/things/config/fetch_property_list'
    things_fetch_property_group_list = '/things/config/fetch_property_group_list'

    things_fetch_property_type_details = '/things/fetch_property_type_details'
    things_save_property_type = '/things/save_property_type'
    things_list_property_type = '/things/list_property_type'
    things_delete_property_type = '/things/delete_property_type'

    things_fetch_thing_details = '/things/fetch_thing_details'
    things_fetch_property_list_in_thing_category = '/things/fetch_property_list_in_thing_category'
    things_save_thing = '/things/save_thing'
    things_left_side_bar = '/things/left_side_bar'
    things_list_tag_category = base_url + '/thing_model/list_tag_category'
    things_fetch_tag_category = base_url + '/thing_model/fetch_tag_category'
    things_fetch_tags = base_url + '/thing_model/list_tags'

    # Device Manager
    save_device = "/device_manager/save_device"
    list_devices = "/device_manager/device/list"
    get_device_details = "/device_manager/device/get"
    save_device_group = "/device_manager/save_device_group"
    list_device_group = "/device_manger/device_group/list"
    get_device_group_details = "/device_manger/device_group/get"
    get_model_catalog = "/device_manager/model/catalog"
    save_model_catalog = "/device_manager/save_model"
    download_device_configurations = "/device_manager/download_configurations"
    download_agent_installation_script = "/device_manager/download/<file_name>"
    agent_update_status = "/device_manager/update_status"
    list_supported_devices = "/device_manager/list_device_types"
    get_device_audit_logs = "/device_manager/get_device_audit_log"
    get_deployed_pipelines = "/device_manager/get_deployed_pipelines"
    save_associated_pipelines = "/device_manager/save_associate_pp"
    get_associated_pipelines = "/device_manager/device/fetch_associated_pipelines"
    get_publish_summary = "/device_manager/get_device_details"
    publish_pipelines = "/device_manager/publish_pp"
    get_device_events = "/device_manager/fetch_events"
    retry_device_event = "/device_manager/retry_event"
    get_associated_device_location = "/device_manager/get_associate_location"
    save_associated_device_location = "/device_manager/save_associate_location"
    delete_device = "/device_manager/delete_device"
    delete_device_group = "/device_manager/delete_device_group"

    # Pipeline Builder
    api_build = "/flow_diagram/build"
    api_create = "/flow_diagram/create"
    api_delete = "/flow_diagram/delete"
    api_list = "/flow_diagram/list"
    api_get = "/flow_diagram/get"
    api_deploy = "/flow_diagram/deploy"
    api_load_nodes = "/flow_diagram/load_nodes"
    api_load_categories = "/flow_diagram/load_categories"
    api_create_new_pipeline_instance = '/flow_diagram/create_new_instance'
    api_create_pipeline_options = '/flow_diagram/create_pipeline_options'
    api_download_win_build =  '/flow_diagram/download_win_build'

    # custom nodes
    create_node = "/flow_diagram/node/create"
    fetch_node = "/flow_diagram/node/fetch"
    delete_node = "/flow_diagram/node/delete"
    job_list = "/flow_diagram/job_list"
    get_template = "/flow_diagram/node/get_template"
    get_job_log = "/flow_diagram/job/get_log"
    api_get_deployment_logs = "/flow_diagram/job/get_deployment_log"
    api_create_nodes = "/flow_diagram/set"
    api_get_deployment_config = '/flow_diagram/get_pipeline_debug_topic_map'
    api_save_node_custom_config = '/flow_diagram/save_node_custom_config'
    api_category_all = '/flow_diagram/category/record'
    api_category_list = '/flow_diagram/category/get_category_list'
    api_list_components = '/flow_diagram/component/get_components_list'
    api_make_component_public = '/flow_diagram/component/enable_public'

    # Scada
    hmi_get_tabledata = "/hmi/hmi_get_tabledata"
    hmi_edit = "/hmi/edit"
    hmi_update_svg = '/hmi/update_svg'
    hmi_create_check_folder = '/hmi/create_check_folder'
    file_render = '/file_render/<path:path>'
    hmi_svg_create = "/hmi/svg_create"
    hmi_asset_create = "/hmi/asset_create"
    create_file = "/create_file/"
    hmi_export = "/hmi/export"
    hmi_import = "/hmi/import"
    hmi_get_topic_list = "/hmi/get_topic_list"
    hmi_get_user_list = "/hmi/get_user_list"
    hmi_pinning_order = "/hmi/hmi_pinning_order"
    download_file = "/download_file/<path>"
    hmi_asset_delete = "/hmi/asset/delete"
    hmi_move_assets = "/hmi/move_assets"
    hmi_user_workgroup_list = "/hmi/user_workgroup_list"
    hmi_user_workgroup_list_for_hmi_share = "/hmi/user_workgroup_list_for_hmi_share"
    hmi_current_user_details = "/hmi/current_user_details"
    hmi_name_update = "/hmi/name_update"
    hmi_high_availibity_topics = "/hmi/high_availibity_topics"
    hmi_audit_scada = '/hmi/audit_scada'
    hmi_share = '/hmi/share'
    hmi_create = '/hmi/create'
    hmi_left_side_bar = '/hmi/left_side_bar'
    hmi_get_template = '/hmi/get_template'
    hmi_tags = '/hmi/tags'
    hmi_update = '/hmi/update'
    hmi_delete = '/hmi/delete'
    sld_config = '/sld/config'
    hmi_site_hierarchy = "/hmi/site_hierarchy"
    hmi_move = "/hmi/move"
    hmi_site_level_hierarchy = "/hmi/get_site_level_hierarchy"
    hmi_fetch_tags = "/hmi/fetch_tags"
    live_tags = "/hmi/live_tags"

    # Protocol Module
    list_protocols = base_url + "/list_protocols"
    create_protocol = base_url + "/create_protocol"
    get_protocol = base_url + "/get_protocol"
    delete_protocol = base_url + "/delete_protocol"

    # ai rule engine
    list_ai_models = base_url + "/list_ai_models"
    fetch_model_detail = base_url + "/fetch_model_detail"
    create_ai_rule = base_url + "/create_ai_rule"
    get_ai_rule = base_url + "/get_ai_rule"
    delete_ai_rule = base_url + "/delete_ai_rule"
    list_ai_rules = base_url + "/list_ai_rules"

    # lookup table
    list_look_up_table = base_url + "/list_look_up_table"
    save_lookup_table = base_url + "/save_look_up_table"
    get_lookup_table = base_url + "/get_lookup_table"
    delete_lookup_table = base_url + "/delete_lookup_table"

    # mobile_urls
    get_alarm_mobile = "/mobile_alarms/get_alarms"
    mobile_login = "/mobile_login/login"
    list_dashboards = "/mobile_visualization/list_dashboards"
    list_widgets = "/mobile_visualization/list_widgets"

    # Captcha
    captcha_image = base_url + '/get_captcha_image'
    validate_captcha = base_url + '/validate_captcha'

    # License
    registration_file = base_url + '/get_registration_file'
    upload_license = base_url + '/upload_license'

    # Dashboard List
    save_dashboards = '/save_dashboards'
    get_dashboards = '/get_dashboards'

    get_token = base_url + '/get_token'

    # Shifts
    get_shifts = base_url + '/get_shifts'
    get_time_frequencies = base_url + '/get_time_frequencies'

    api_to_get_mongo_details = base_url + "/get_mongo_details"


class CustomerProjects:
    customer_project_id = "customer_project_id"
    site_templt_id = "site_templt_id"
    process_templt_id = "process_templt_id"


class SiteConfiguration:
    table_actions = {"enableActions": True, "actions": [{"label": "Edit", "type": "edit", "action": "edit"},
                                                        {"label": "Delete", "type": "delete", "action": "delete"}],
                     "externalActions": [{"label": "Create New", "type": "addnew", "action": "addnew"}]}
    site_list_header = [{"value": "site_name", "label": "Site Name"}, {"value": "country", "label": "Country"},
                        {"value": "state", "label": "Region"}, {"value": "status", "label": "Status"}]
    custom = {"dept": [{"value": "dept_name", "label": "Plant Name"},
                       {"value": "dept_description", "label": "Description"}],
              "line": [{"value": "line_name", "label": "Line Name"},
                       {"value": "line_description", "label": "Description"}],
              "equipment": [{"value": "equipment_name", "label": "Equipment Name"},
                            {"value": "equipment_description", "label": "Description"},
                            {"value": "m_id", "label": "Machine ID"}, {"value": "make_model", "label": "Make & Model"}]}
    dfm_static_json = {"allowClear": False, "emitChanges": True, "dependent": False, "disabled": False,
                       "example": "Monday", "gridWidth": "3", "key": "", "label": "Select ",
                       "options": [], "placeholder": "", "required": False, "type": "select", "value": ""}


class ProjectConfig:
    date_format = "%d-%m-%Y %H:%M:%S"
    header_json = {"template_name": "Template Name", "site_hierarchy": "Site Hierarchy",
                   "process_hierarchy": "Process Hierarchy", "project_Name": "Project Name"}
    customer_project_id = "customer_project_id"
    customer_project_name = "customer_project_name"
    logo_url = "logo_url"
    site_templt_name = "site_templt_name"
    site_templt_id = "site_templt_id"
    process_templt_id = "process_templt_id"
    process_templt_name = "process_templt_name"
    update_details = "update_details"
    description = "description"
    logo_name = "logo_name"


class Units:
    unit_id = "id"
    unit_name = "name"
    notation = "notation"
    unit_group_id = "unit_group_id"
    from_unit_id = "from_unit_id"
    to_unit_id = "to_unit_id"
    mul_factor = "mul_factor"
    group_name = "group_name"
    description = "description"
    type_list = ["units", "unit_conversion", "unit_group"]
    header_action = [{"type": "edit", "action": "edit", "label": "Edit"},
                     {"type": "delete", "action": "delete", "label": "Delete"}]
    external_action = [{"label": "", "type": "upload", "action": "upload"},
                        {"type": "addnew", "action": "addnew", "label": "Create New"},
                       {"label": "", "type": "download", "action": "download"},
                       ]
    external_action_for_unit_conversion = [{"type": "addnew", "action": "addnew", "label": "Create New"},
                       {"label": "", "type": "download", "action": "download"},
                       ]
    external_action_for_unit_group = [{"type": "addnew", "action": "addnew", "label": "Create New"},
                       {"label": "", "type": "download", "action": "download"},
                       ]
    table_header = [{"label": "Unit", "key": "unit"}, {"label": "Notation", "key": "notation"},
                    {"label": "Unit Group Name", "key": "unit_group_name"}]
    converter_table_header = [{"label": "From Unit Name", "key": "from_unit_name"},
                              {"label": "To Unit Name", "key": "to_unit_name"},
                              {"label": "Multiply the length value with", "key": "multiply_with"}]
    group_table_header = [{"label": "Unit group Name", "key": "unit_group_name"},
                          {"label": "Description", "key": "description"}]
    preview_table_header = [{
        "key": '',
        "label": '',
        "inLineStye": {"width": '25px', 'max-width': '25px', 'vertical-align': 'middle', "overflow": 'unset'},
        "type": 'icon',
        "enableTooltip": True,
        "tooltip": 'in_valid_message',
        "iconClass": 'in_valid_icon',
    }, {"label": "Unit", "key": "unit"}, {"label": "Notation", "key": "notation"},
                    {"label": "Unit Group Name", "key": "unit_group_name"}]
    required_columns_list_in_csv = ['Unit', 'Notation', 'Unit Group Name']
    unit_group_data = [{"label" : "Speed","value" : "group_102"}, {"label": "Distance", "value": "group_100"},
                 {"label": "Percentage", "value": "group_101"}, {"label": "Temperature", "value": "group_102"},
                 {"label": "Flow", "value": "group_103"}, {"label": "Pressure", "value": "group_104"},
                 {"label": "pH", "value": "group_103"}, {"label": "Concentration", "value": "group_106"}, {"label": "No Unit", "value": "group_107"},
                 {"label": "Weight", "value": "group_108"}, {"label": "Relay", "value": "group_109"},
                 {"label": "EMS tags", "value": "group_111"}, {"label": "Unit_Test", "value": "group_112"},
                 {"label": "Voltage", "value": "group_113"}, {"label": "Meter Testing", "value": "group_116"},
                {"label": "Weight", "value": "group_120"}, {"label": "Test_BA", "value": "group_121"},
                 {"label": "Speeds", "value": "group_122"},{"label": "Speed_23", "value": "group_123"}]



class Tags:
    tag_name = "tag_name"
    tag_unit = "unit"
    tag_type = "tag_type"
    tag_description = "description"
    tag_id = "id"
    group_id = "id"
    tag_group_id = "tag_group_id"
    tag_group_name = "tag_group_name"
    tag_group_description = "description"
    data_type = "data_type"
    value_list = "value_list"
    type_list = ["tags", "tag_groups", "tag_category"]
    header_action = [{"type": "edit", "action": "edit", "label": "Edit"},
                     {"type": "delete", "action": "delete", "label": "Delete"}]
    external_action_for_tag = [{"label": "", "type": "upload", "action": "upload"},
                               {"type": "addnew", "action": "addnew", "label": "Create New"},
                               {"label": "", "type": "download", "action": "download"}
                               ]
    external_action_for_tag_group = [{"type": "addnew", "action": "addnew", "label": "Create New"},
                                     {"label": "", "type": "download", "action": "download"}]
    external_action_for_tag_category = [{"type": "addnew", "action": "addnew", "label": "Create New"},
                                        {"label": "", "type": "download", "action": "download"}
                                        ]
    tag_table_header = [{"label": "Tag Name", "key": "tag_name"},{"label": "Tag Description", "key": "description"},
                        {"label": "Unit", "key": "unit_name" },{"label": "Tag Group", "key": "tag_group_name"},
                        {"label": "System Tag Type", "key": "system_tag_label"},
                        {"label": "Data type","key": "data_type_name"},
                        {"label": "Tag Type", "key": "tag_type_name"}]
    preview_table_header = [{
        "key": '',
        "label": '',
        "inLineStye": {"width": '25px', 'max-width': '25px', 'vertical-align': 'middle', "overflow": 'unset'},
        "type": 'icon',
        "enableTooltip": True,
        "tooltip": 'in_valid_message',
        "iconClass": 'in_valid_icon',
    }, {"label": "Tag Name", "key": "tag_name"}, {"label": "Tag Type", "key": "tag_type"},
        {"label": "Description", "key": "description"}, {"label": "Tag Group", "key": "tag_group_name"},
        {"label": "System Tag Type", "key": "system_tag_label"}]
    required_columns_list_in_csv = ['Tag Name', 'Tag Description', 'Unit', 'Tag Group', 'System Tag Type', 'Data type',
                                    'Tag Type']
    tag_group_header = [{"label": "Tag Group Name", "key": "tag_group_name"},
                        {"label": "Description", "key": "description"}]
    tag_category_header = [{"label": "Tag Category Name", "key": "tag_category_name"},
                           {"label": "Description", "key": "description"}]
    dataTypes = [{"label": "Integer", "value": "integer"}, {"label": "Float", "value": "float"},
                 {"label": "Swapped Float", "value": "swapped_float"}, {"label": "Long Int", "value": "long_int"},
                 {"label": "Swapped Long Int", "value": "swapped_long_int"}, {"label": "Double", "value": "double"},
                 {"label": "Swapped Double", "value": "swapped_double"},
                 {"label": "2Integer String", "value": "2integer_string"}, {"label": "Date Time", "value": "date_time"},
                 {"label": "Color", "value": "color"}]
    tagTypes = [{"label": "Text Entry", "value": "text"}, {"label": "Numeric Entry", "value": "number"},
                {"label": "Single Select", "value": "select"}, {"label": "Multiselect", "value": "multiselect"},
                {"label": "Radio group", "value": "radio"}, {"label": "Boolean", "value": "boolean"}]
    systemTagType = [{"label": "Raw", "value": "raw_tag"}, {"label": "Derived", "value": "derived_tag"},
                     {"label": "Alarm", "value": "alarm_tag"}, {"label": "Product", "value": "product_tag"},
                     {"label": "Manual", "value": "manual_tag"}]
    system_attributes = [{"name": "value", "attr_type": "system", "type": "tag",
                          "qualifier": True, "attribute_id": "attribute_99", "value": ""},
                         {"name": "dtValue", "attr_type": "system", "type": "calcInput",
                          "qualifier": True, "attribute_id": "attribute_98", "value": {}
                          }]


class ProcessConfiguration:
    table_actions = {"enableActions": True, "actions": [{"label": "Edit", "type": "edit", "action": "edit"},
                                                        {"label": "Delete", "type": "delete", "action": "delete"}],
                     "externalActions": [{"label": "Create New", "type": "addnew", "action": "addnew"}]}
    process_list_header = [{"value": "process_name", "label": "Process Name"},
                           {"value": "description", "label": "Description"}]
    custom = {"step": [{"value": "step_name", "label": "Step Name"}, {"value": "step_icon", "label": "Icon"}],
              "activity": [{"value": "activity_name", "label": "Activity Name"},
                           {"value": "description", "label": "Description"}]}



class UserAccess:
    user_id = "user_id"
    username = "username"
    email = "email"
    name = "name"
    userrole = "userrole"
    access_group = "access_group"
    access_group_ids = "access_group_ids"
    access_group_id = "access_group_id"
    access_list = "access_list"
    description = "description"
    access_list_action = [{"label": "Edit", "type": "edit", "action": "edit"},
                          {"label": "Delete", "type": "delete", "action": "delete"}]
    access_list_external_action = [{"label": "Create New", "type": "addnew", "action": "addnew"}]
    access_list_header_content = [{"label": "Access Group", "key": "access_group"},
                                  {"label": "Description", "key": "description"}]
    list_all_user_header = [{"label": "iLens ID", "key": "username"}, {"label": "Full Name", "key": "full_name"},
                            {"label": "Email", "key": "e_mail"}, {"label": "Role", "key": "role"},
                            {"label": "Access Group", "key": "access_group"}]
    user_details_header = [{"key": "name", "label": "Name"}, {"key": "username", "label": "User Name"},
                           {"key": "email", "label": "Email"}, {"key": "phonenumber", "label": "Phone Number"},
                           {"key": "userrole", "label": "User Role"}, {"key": "created_by", "label": "Created By"}]
    user_role_name = "user_role_name"
    user_role_description = "user_role_description"
    user_role_id = "user_role_id"
    user_role_header = [{"label": "Role", "key": "role"}, {"label": "Description", "key": "description"}]
    password_decryption_key = 'QVY1bWdMQ0Zxc'


class Account:
    unplanned_id = "notification_01"
    planned_id = "notification_02"
    email_preferences = "email_preferences"
    user_action_json = {"addOptionalFields": {"enableAdd": False,
                                              "modalInfo": {"config": "profile", "modalTitle": "Profile Information"}}}
    default_notification_data = [{"heading": "Unplanned events",
                                  "description": "Receive emails about issues that can cause an outage",
                                  "notification_id": unplanned_id, "value": False},
                                 {"heading": "Planned events",
                                  "description": "Receive emails about maintenance that is required to "
                                                 "keep the platform operating at optimal status",
                                  "notification_id": planned_id, "value": False}]


class Shift:
    template_list_1 = ["site", "equipment"]
    template_list_2 = ["site", "line", "equipment"]
    template_list_3 = ["site", "dept", "line", "equipment"]
    template_list_4 = ["site", "dept", "equipment"]
    actions_list = [{"action": "edit", "label": "Edit", "type": "edit"},
                    {"action": "delete", "label": "Delete", "type": "delete"}]
    external_actions_list = [{"action": "addnew", "label": "Create New", "type": "addnew"},
                             {"action": "download", "label": "", "type": "download"}]
    header_content = [{"key": "shift_name", "label": "Shift Name"}, {"key": "description", "label": "Description"}]
    load_shift_tableAction_json = {"actions": [{"action": "edit", "label": "Edit", "type": "edit"},
                                               {"action": "delete", "label": "Delete", "type": "delete"}],
                                   "enableActions": True,
                                   "externalActions": [{"action": "addnew", "label": "Create New", "type": "addnew"}],
                                   "externalView": [{"action": "tableView", "label": "Table View",
                                                     "type": "tableView"}]}
    load_shift_headerContent = [{"key": "activity_name", "label": "Activity Name"},
                                {"key": "activity_duration", "label": "Activity Duration", "box_style": True}]


class TimeSettings:
    hours = "hours"
    minutes = "minutes"
    seconds = "seconds"
    days = "days"
    weeks = "weeks"
    time_type_list = [hours, minutes, seconds, days, weeks]
    time_freq_json = {
        hours: {"Every 1 hr": 1, "Every 2 hr": 2, "Every 3 hr": 3, "Every 4 hr": 4, "Every 5 hr": 5, "Every 6 hr": 6,
                "Every 7 hr": 7, "Every 8 hr": 8, "Every 9 hr": 9, "Every 10 hr": 10, "Every 11 hr": 11,
                "Every 12 hr": 12, "Every 13 hr": 13, "Every 14 hr": 14, "Every 15 hr": 15, "Every 16 hr": 16,
                "Every 17 hr": 17, "Every 18 hr": 18, "Every 19 hr": 19, "Every 20 hr": 20, "Every 21 hr": 21,
                "Every 22 hr": 22, "Every 23 hr": 23, "Every 24 hr": 24},
        days: {},
        weeks: {},
        minutes: {},
        seconds: {}
    }

    time_type_json = {"Hour": hours, "Day": days, "Minutes": minutes, "Seconds": seconds, "Week": weeks}


class Rule:
    actions = [{"action": "edit", "label": "Edit", "type": "edit"},
               {"action": "delete", "label": "Delete", "type": "delete"},
               {"type": "clone", "action": "clone", "label": "Clone"}]
    external_actions = [{"action": "addnew", "label": "Create New", "type": "addnew"}]
    header_content = [{"key": "rule", "label": "Rule"}, {"key": "description", "label": "Description"}]


class MasterDev:
    threshold_table_actions = {"actions": [{"action": "edit", "label": "Edit", "type": "edit"},
                                           {"action": "delete", "label": "Delete", "type": "delete"}],
                               "enableActions": True,
                               "externalActions": [{"action": "addnew", "label": "Create New", "type": "addnew"}]}
    threshold_header_content = [{"label": "Threshold Name", "value": "name"},
                                {"label": "Description", "value": "description"}, {"label": "Value", "value": "value"}]


class RequestMethods:
    GET = "GET"
    POST = "POST"


class AppTimeFormats:
    USER_META_TIME_FORMAT = "%d-%m-%Y %H:%M:%S"


class CommonKeys:
    KEY_CREATED_BY = "created_by"
    KEY_CREATED_TIME = "created_time"
    KEY_LAST_UPDATED_BY = "last_updated_by"
    KEY_LAST_UPDATED_TIME = "last_updated_time"


class ChannelPipeLineURL:
    # API Endpoints:
    base_url = "/channel_pipeline/"

    # config
    api_left_side_view = base_url + "left_side_view"

    # meta data for pipeline
    api_get_conf_data = base_url + "get_conf_data"
    api_get_uploader_conf = base_url + "get_uploader_conf"

    # Pipeline
    api_get_site_data = base_url + "get_site_data"
    api_save_channel_pp = base_url + "save_channel_pp"
    api_list_channel_pp = base_url + "list_channel_pp"
    api_delete_channel_pp = base_url + "delete_channel_pp"
    api_fetch_channel_pp = base_url + "fetch_channel_pp"
    api_pp_version = base_url + "pp_version"
    api_save_flow = base_url + "save_flow"

    # Custom code
    api_get_template = base_url + "get_template"
    api_save_cc_to_pp = base_url + "save_cc_to_pp"

    # device manager
    api_get_associate_pp = base_url + "get_associate_pp"
    api_save_associate_pp = base_url + "save_associate_pp"
    api_get_debugger_component = base_url + "get_debugger_component"


class Printer:
    header_content = [{"key": "job_id", "label": "Job ID"}, {"key": "job_name", "label": "Job Name"},
                      {"key": "owner", "label": "Owner"}, {"key": "start_time", "label": "Start Time"},
                      {"key": "end_time", "label": "End Time"}, {"key": "remark", "label": "Remark"},
                      {"key": "status", "label": "Status"}]


class RequiredFields:
    # below variables are used to validate the required fields for property type
    property_type_list = ["columns", "order", "start", "length", "column_search"]
    property_type_create = ["property_type_name"]
    property_type_edit = ["property_type_id", "property_type_name", "attribute_list"]
    property_type_delete = ["property_type_id"]

    # below variables are used to validate the required fields for property
    property_list = ["columns", "order", "start", "length", "column_search"]
    property_create = ["property_name", "property_type_id", "uom", "attribute_list"]
    property_edit = ["property_id", "property_name", "uom", "attribute_list"]
    property_delete = ["property_id"]

    # below variables are used to validate the required fields for property group
    property_group_list = ["columns", "order", "start", "length", "column_search"]
    property_group_create = ["property_group_name", "property_list"]
    property_group_edit = ["property_group_id", "property_group_name", "property_list"]
    property_group_delete = ["property_group_id"]

    # below variables are used to validate the required fields for property category
    tag_category_list = ["columns", "order", "start", "length", "column_search"]
    property_category_create = ["property_category_name", "property_category_icon", "property_list"]
    property_category_edit = ["property_category_id", "property_category_name", "property_list"]
    property_category_delete = ["property_category_id"]

    # below variables are used to validate the required fields for property category
    thing_list = ["columns", "order", "start", "length", "column_search"]
    thing_create = ["metadata", "categories"]
    thing_edit = ["metadata", "categories"]
    thing_delete = ["thing_id"]


class DeviceManagerConstants(object):
    ILENS_SUPPORTED_DEVICES = [
        {"label": 'ILENS-SCMX100', "value": 'ILENS-SCMX100', "type": 'Pi'},
        {"label": 'ILENS-SCM101', "value": 'ILENS-SCM100', "type": 'Pi'},
        {"label": 'ILENS-SCM101', "value": 'ILENS-SCM101', "type": 'Pi'},
        {"label": 'ILENS-EIM100 (Linux)', "value": 'ILENS-EIM100 (Linux)', "type": 'linux'}
    ]

    DEVICE_MANAGER_CONFIG = {
        "apiUrl": "https://beta.ilens.io/cloud/device_manager/update_status",
        "agentImage": "ailens-registry.knowledgelens.com:9084/kl-docker-repo/metastax/ilens/ilens-agent1:0.1.1",
        "registry": "acrilens.azurecr.io",
        "registryUsername": "acrilens",
        "registryPassword": "cxgMoBG5Wgr10sM1kV83Oh=mvwYdxwp3",
        "messageBrokerHost": "beta.ilens.io",
        "messageBrokerPort": 1883,
        "scriptTemplatePi": "templates/debian_template",
        "scriptTemplateubuntu": "templates/centos_template"
    }

    DEFAULT_DEVICE_STATISTICS = {"cpu_usage": 0, "cpu_temparature": 0, "no_of_disks": 0, "discs": {}, "ram_usage": 0}
    ILENS_AGENT = 'ilens-agent'
    AGENT_VERSION = 'v3.2'

    LICENSE_ENABLED = {
        "4.3": True
    }


class Pipeline:
    default_json = {"project_id": "", "pipeline_name": "", "pipeline_description": "", "type": "", "data": {},
                    "pipeline_id": "", "thread": 1, "status": "Pending", "container_id": "",
                    "pipeline": {}, "flow": {}, "counter": 0, "created_by": "", "created_at": "", "last_edited_by": "",
                    "isdeleted": "false", "target_device_type": "", "pipeline_category": "", "pipeline_type": ""}

    header_content = [{"label": "S.No", "value": "sno"}, {"label": "Pipeline Name", "value": "pipeline_name"},
                      {"label": "Pipeline Description", "value": "pipeline_description"},
                      {'label': "Execution Type", "value": "pipeline_type"},
                      {'label': "Target Device Type", "value": "target_device_type"},
                      {"label": "Last Edited By", "value": "last_edited_by"}]

    job_list_header_content = [{"key": "job_id", "label": "Job ID"}, {"key": "job_name", "label": "Job Name"},
                               {"key": "owner", "label": "Owner"}, {"key": "start_time", "label": "Start Time"},
                               {"key": "end_time", "label": "End Time"}, {"key": "remark", "label": "Remark"},
                               {"key": "status", "label": "Status"}]
    category_list_header = [{"label": "Categories Id", "value": "category_id"},
                            {"label": "Category Name", "value": "category_name"},
                            {"label": "Category Description", "value": "category_description"},
                            {"label": "Last Updated By", "value": "last_updated_by"},
                            {"label": "Last Updated Time", "value": "last_updated_time"}]
    component_list_header = [{"label": "Component Name", "value": "component_name"},
                             {"label": "Component Category", "value": "component_category"},
                             {"label": "Last Updated By", "value": "last_updated_by"},
                             {"label": "Last Updated Time", "value": "last_updated_time"}]

    get_status = "/get_list"
    launch_container = "/launch_container"
    stop_container = "/stop_container"
    delete_container = "/delete_container"
    restart_container = "/restart_container"
    job_log_url = "/get_job_log"
    deployment_job_url = "/get_deployment_log"
    build_pipeline = '/build_container'
    windows_build = '/windows_build'
    save_node = '/save_node'
    delete_component = '/delete_node'

    # Constants
    key_project_id = 'project_id'
    key_pipeline_id = 'pipeline_id'
    key_pipeline_name = 'pipeline_name'
    key_pipeline_desc = 'pipeline_description'
    key_pipeline_instance_id = 'pipeline_instance_id'
    key_pipeline_category = 'pipeline_category'
    key_pipeline_category_id = 'category_id'
    key_pipeline_category_name = 'category_name'
    category_ai = 'ai'
    category_normal = 'normal'
    category_acquisition = 'acquisition'
    key_node_type = 'node_type'
    component_type_docker = 'docker_image'
    component_type_code = 'custom'
    is_pipeline_deployment_on_premise = False

    pipeline_categories = [
        {'label': "Single Container", 'value': 'normal'},
        {'label': "Multi Container", 'value': 'ai'}
    ]
    updated_pipeline_categories = [
        {'label': "Single Container", 'value': 'normal'}
    ]
    acquisition_pipeline_category = {'label': "No Container", 'value': "acquisition"}

    ACQUISITION_TOPIC = "ilens_rockwell_acquisition"
    ACQUISITION_PORT_KAFKA = '9092'


class DeviceConstants:
    LAST_UPDATED_BY = "last_updated_by"
    LAST_UPDATED_TIME = "last_updated_time"
    DATETIME_FORMAT = "%d %b %Y %H:%M"
    CREATED_TIME = "created_time"
    CREATED_BY = "created_by"
    TIMESTAMP = "time_stamp"
    META = "meta"
    TABLE_DATA = "tableData"
    BODY_CONTENT = "bodyContent"
    HEADER_CONTENT = "headerContent"
    POST = "POST"
    GET = "GET"
    CREATED_USER = "created_user"
    LAST_UPDATED_USER = "last_updated_user"
    ADMIN_USER = "system_admin"
    USER_ID = "user_id"
    CLIENT_ID = "client_id"
    STATISTICS = "statistics"
    PIPELINE_CATEGORY = "pipeline_category"

    # Agent installation
    # AGENT SOURCE(S3)

    BUCKET = "ilens-repo"
    ACCESS_KEY = "AKIA5FK63PYZGHPCRAQN"
    SECRET_KEY = "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"
    REGION = "us-east-1"
    URL_EXPIRES_IN = 3600


class DeviceConfiguration:
    KEY_DEVICE_GROUP_ID = "physical_device_group_id"
    KEY_DEVICE_ID = "ilens_device_id"
    KEY_DEVICE_NAME = "device_name"
    KEY_DEVICE_TYPE = "device_type"
    MODEL_TO_DEVICE_DEPLOYMENT_CONFIGURATIONS = "model_device_configurations"
    BATCH_JOBS_COLLECTION = "batch_jobs"
    DEVICE_INFO_COLLECTION = "ilens_devices"
    DEVICE_EVENTS_COLLECTION = "device_events"
    DEVICE_GROUP_NAME = "device_group_name"
    DEVICE_GROUP_DESCRIPTION = "device_group_description"
    APPLICATION_VERSION = "application_version"
    APPLICATION_VERSION_VALUE = "5.0"
    FIRM_WARE_VERSION = "firm_ware_version"
    FIRM_WARE_VERSION_VALUE = "4.6"
    PIPELINE_CATEGORY = "pipeline_category"

    DEVICES = [
        {"label": 'ILENS-SCMX100', "value": 'ILENS-SCMX100', "type": 'pi'},
        {"label": 'ILENS-SCM100', "value": 'ILENS-SCM100', "type": 'pi'},
        {"label": 'ILENS-SCM101', "value": 'ILENS-SCM101', "type": 'pi'},
        {"label": 'ILENS-SCN100', "value": 'ILENS-SCN100', "type": 'pi'},
        {"label": 'ILENS-EIM100 (Linux)', "value": 'ILENS-EIM100 (Linux)', "type": 'linux'}
    ]

    DEVICE_MANAGER_CONFIG = {
        "apiUrl": "https://beta.ilens.io/cloud/device_manager/update_status",
        "agentImage": "ailens-registry.knowledgelens.com:9084/kl-docker-repo/metastax/ilens/ilens-agent1:0.1.1",
        "registry": "acrilens.azurecr.io",
        "registryUsername": "acrilens",
        "registryPassword": "cxgMoBG5Wgr10sM1kV83Oh=mvwYdxwp3",
        "messageBrokerHost": "beta.ilens.io",
        "messageBrokerPort": 1883,
        "scriptTemplatePi": "templates/debian_template",
        "scriptTemplateubuntu": "templates/centos_template"
    }
    STATISTICS = {"cpu_usage": "0", "cpu_temparature": "0", "no_of_disks": "0", "discs": {}, "ram_usage": "0"}
    DEVICE_LIST_HEADER = [{"key": "device_name", "label": "Device Name"},
                          {"key": "created_user", "label": "Device Added By"},
                          {"key": "device_type", "label": "Device Type"},
                          {"key": "version", "label": "Version", "parameters": [
                              {"key": "application_version", "label": "Application Version"},
                              {"key": "firm_ware_version", "label": "Firmware Version"}]},
                          {"key": "status", "label": "Status"}, {"key": "ip-address", "label": "IP Address"},
                          {"key": "cpu_usage", "label": "CPU"}, {"key": "ram_usage", "label": "RAM"},
                          {"key": "lastHeartBeatAt", "label": "Last Heart Beat At"},
                          {"key": "license_status", "label": "License Status"}]


class FlowURL:
    # Blueprint:
    service_blueprint = "flow_configuration"
    # API Endpoints:
    base_url = "/flow_diagram/"
    # build
    api_build = base_url + "build"
    api_create = base_url + "create"
    api_delete = base_url + "delete"
    api_list = base_url + "list"
    api_get = base_url + "get"
    api_deploy = base_url + "deploy"
    api_load_nodes = base_url + "load_nodes"
    api_load_categories = base_url + "load_categories"
    api_create_new_pipeline_instance = base_url + 'create_new_instance'
    # custom nodes
    create_node = base_url + "node/create"
    fetch_node = base_url + "node/fetch"
    delete_node = base_url + "node/delete"
    job_list = base_url + "job_list"
    get_template = base_url + "node/get_template"
    get_job_log = base_url + "job/get_log"
    api_get_deployment_logs = base_url + "job/get_deployment_log"

    # custom nodes
    api_create_nodes = base_url + "set"
    api_get_deployment_config = base_url + 'get_pipeline_debug_topic_map'
    api_save_node_custom_config = base_url + 'save_node_custom_config'

    # category block
    api_category_all = base_url + 'category/record'
    api_category_list = base_url + 'category/get_category_list'

    # component urls
    api_list_components = base_url + 'component/get_components_list'
    api_make_component_public = base_url + 'component/enable_public'

    default_json = {"pipeline_name": "", "pipeline_description": "", "type": "", "data": {},
                    "pipeline_id": "", "thread": 1, "status": "Pending", "container_id": "",
                    "pipeline": {}, "flow": {}, "counter": 0, "created_by": "", "created_at": "", "last_edited_by": "",
                    "isdeleted": "false", "target_device_type": "", "pipeline_category": "", "pipeline_type": ""}

    header_content = [{"label": "S.No", "value": "sno"}, {"label": "Pipeline Name", "value": "pipeline_name"},
                      {"label": "Pipeline Description", "value": "pipeline_description"},
                      {'label': "Execution Type", "value": "pipeline_type"},
                      {'label': "Target Device Type", "value": "target_device_type"},
                      {"label": "Last Edited By", "value": "last_edited_by"},
                      {"label": "Status", "value": "status"}]

    job_list_header_content = [{"key": "job_id", "label": "Job ID"}, {"key": "job_name", "label": "Job Name"},
                               {"key": "owner", "label": "Owner"}, {"key": "start_time", "label": "Start Time"},
                               {"key": "end_time", "label": "End Time"}, {"key": "remark", "label": "Remark"},
                               {"key": "status", "label": "Status"}]
    category_list_json = {"status": "success", "data": {"headerContent": [
        {"label": "Categories Id", "value": "category_id"}, {"label": "Category Name", "value": "category_name"},
        {"label": "Category Description", "value": "category_description"},
        {"label": "Last Updated By", "value": "last_updated_by"},
        {"label": "Last Updated Time", "value": "last_updated_time"}], "bodyContent": []}}
    get_status = "/get_list"
    launch_container = "/launch_container"
    stop_container = "/stop_container"
    delete_container = "/delete_container"
    restart_container = "/restart_container"
    job_log_url = "/get_job_log"
    deployment_job_url = "/get_deployment_log"
    build_pipeline = '/build_container'
    save_node = '/save_node'

    # Constants
    key_pipeline_id = 'pipeline_id'
    key_pipeline_name = 'pipeline_name'
    key_pipeline_desc = 'pipeline_description'
    key_pipeline_instance_id = 'pipeline_instance_id'
    key_pipeline_category = 'pipeline_category'
    key_pipeline_category_id = 'category_id'
    key_pipeline_category_name = 'category_name'
    category_ai = 'ai'
    category_normal = 'normal'
    category_acquisition = 'acquisition'
    key_node_type = 'node_type'
    component_type_docker = 'docker_image'
    component_type_code = 'custom'
    is_pipeline_deployment_on_premise = False

    pipeline_categories = [{'label': "Single Container", 'value': 'normal'},
                           {'label': "Multi Container", 'value': 'ai'}]
    acquisition_pipeline_category = {'label': "No Container", 'value': "acquisition"}


class DownTimeReason:
    table_header = [{"label": 'Downtime Reason', "key": 'name', "style": 'indicate-item'},
                    {"label": 'Downtime Type', "key": 'category'}]


class ProtocolConfig:
    table_actions = {"actions": [{"action": "edit", "label": "Edit", "type": "edit"},
                                 {"action": "delete", "label": "Delete", "type": "delete"}],
                     "enableActions": True, "externalActions":
                         [{"action": "addnew", "label": "Create New", "type": "addnew"}]}
    table_header = [{"label": "Protocol Name", "value": "name", "style": "indicate-item"},
                    {"label": "Description", "value": "description"}, {"label": "Type", "value": "type"}]


class AIRuleEngine:
    table_action = {"actions": [{"action": "edit", "label": "Edit", "type": "edit"},
                                {"action": "delete", "label": "Delete", "type": "delete"}],
                    "enableActions": True, "externalActions":
                        [{"action": "addnew", "label": "Create New", "type": "addnew"}]}


class LookupTable:
    table_action = {"actions": [{"action": "edit", "label": "Edit", "type": "edit"},
                                {"action": "delete", "label": "Delete", "type": "delete"}],
                    "enableActions": True, "externalActions":
                        [{"action": "addnew", "label": "Create New", "type": "addnew"}]}


class AlarmTimeMapping:
    allowed_input_data_type = ["last_five_minutes", "last_fifteen_minutes", "last_thirty_minutes",
                               "last_one_hours", "last_three_hours", "last_six_hours", "last_twelve_hours",
                               "last_twenty_four_hours", "today", "today_so_far", "this_week",
                               "this_week_so_far", "this_month", "this_month_so_far", "this_year",
                               "this_year_so_far", "yesterday", "day_before_yesterday",
                               "this_day_last_week", "previous_week", "previous_month", "previous_year",
                               "last_two_days", "last_seven_days", "last_thirty_days", "last_ninety_days",
                               "last_six_month", "last_one_year", "last_two_year", "last_five_year"]
    condition_table_content = [
        {
            "label": "triggered",
            "value": "Triggered on"
        },
        {
            "label": "value",
            "value": "Value"
        },
        {
            "label": "ackNote",
            "value": "Acknowledgement Note"
        }
    ]


class AlarmTable:
    alarm_table_header = {"tableData": {
        "bodyContent": [],
        "headerContent": [
            {
                "key": "alarm_event_selected",
                "label": "Alarm Event Selected",
                "alarm_event_selected": False,
                "type": "check-box",
                "no_label": True,
                "inLineStye": {
                    "width": "32px",
                    "max-width": "32px",
                    "vertical-align": "middle"
                },
                "iconClass": "alarm_acknowledged_icon"
            },
            {
                "key": "priority",
                "label": "Severity",
                "inLineStye": {
                    "width": "85px",
                    "max-width": "85px",
                    "vertical-align": "middle",
                    "overflow": "unset"
                },
                "type": "icon",
                "header_type": "select",
                "enableTooltip": False,
                "tooltip": "alert_info",
                "iconClass": "alert_icon",
                "enable_column_search": True,
                "options": [
                    {
                        "label": "All",
                        "value": "all"
                    },
                    {
                        "label": "Critical",
                        "value": "critical"
                    },
                    {
                        "label": "Moderate",
                        "value": "moderate"
                    },
                    {
                        "label": "Low",
                        "value": "low"
                    }
                ],
                "enable_value_disp": True,
                "value_position": "right",
                "colspan": 1
            },
            {
                "key": "timeStamp",
                "label": "Time Stamp",
                "enable_column_search": False,
                "header_type": "date_range",
                "inLineStye": {
                    "width": "100px",
                    "max-width": "100px"
                }
            },
            {
                "key": "deviceNames",
                "label": "Device Name",
                "enable_column_search": True,
                "header_type": "select",
                "inLineStye": {
                    "width": "200px",
                    "max-width": "200px"
                },
                "options": []
            },
            {
                "key": "tag_name",
                "label": "Tag Name",
                "enable_column_search": True,
                "header_type": "select",
                "inLineStye": {
                    "width": "120px",
                    "max-width": "120px"
                },
                "options": []

            },

            {
                "key": "alert_condition",
                "label": "Alert Condition",
                "enable_column_search": True,
                "header_type": "select",
                "options": [],
                "inLineStye": {
                    "width": "200px",
                    "max-width": "200px"
                },
                "action": {
                    "action": "view",
                    "label": "View",
                    "type": "view"
                },
                "enableClick": True,
                "colspan": 1,
                "rowspan": 1,
                "style": "indicate-item cursor-pointer"
            }

        ]

    },

        "tableActions": {
            "actions": [
                {
                    "action": 'data_viz',
                    "label": 'Data Viz.',
                    "type": 'data_viz',
                    'icon-class': 'fa-pie-chart text-primary',
                },
                {
                    "action": 'acknowledge',
                    "label": 'Acknowledge',
                    "type": 'acknowledge',
                    'icon-class': 'fa-bell text-primary',
                }
            ],

            "enableActions": True,
        },
        "enableActions": True,
        "actions": [],
        "externalActions": [],
        "hideSearch": True,
        "hideExternal": True,
        "enableRowClick": True,
        "table_type": "infinite_scroll",
        "server_search": True,
        "endofrecords": True,
        "rowClass": 'cursor-pointer',
        "rowHighLightClass": 'selected-row',

    }


class AlarmTypes:
    alarm_types = [
        {
            "label": "General",
            "value": "Alarm"
        },
        {
            "label": "Device Status Alarm",
            "value": "device_alarm"
        },
        {
            "label": "Acquisition Status Alarm",
            "value": "acquisition_engine_alarm"
        },
        {
            "label": "Data Push Alarm",
            "value": "data_push_alarm"
        }
    ]


class KEYS:
    cookie_encryption_private_key = "#ilenskey@rock1#"


class staticJson:
    apps_json = [
        {
            "label": "Native Apps",
            "items": [
                {
                    "app_id": "pnp",
                    "app_url": "https://ilens-wps.ilens.io/",
                    "app_name": "Workplace Safety",
                    "app_description": "AI Powered Workplace Safety App.",
                    "app_bg_image": "assets/images/more-apps/workplace-safety.png",
                    "reports": []
                },
                {
                    "app_id": "new_tab",
                    "routeUrl": "p/oee/summary/apps",
                    "app_name": "OEE Dashboard",
                    "app_description": "OEE is a measure of how well a manufacturing operation is utilized compared to its full potential, during the periods when it is scheduled to run.",
                    "app_bg_image": "assets/images/apps/oee.png",
                    "reports": []
                },
                {
                    "app_id": "new_tab",
                    "routeUrl": "p/e-logbook-dashboard/apps",
                    "app_name": "E-Logbook",
                    "app_description": "An electronic logbook is a computer-based software program for recording (logging) states, events and values.",
                    "app_bg_image": "assets/images/apps/logbook.png",
                    "reports": []
                },
                {
                    "app_id": "new_tab",
                    "routeUrl": "p/oee/dashboard/apps",
                    "app_name": "OEE Dashboard (v2)",
                    "app_description": "OEE is a measure of how well a manufacturing operation is utilized compared to its full potential, during the periods when it is scheduled to run.",
                    "app_bg_image": "assets/images/apps/oee.png",
                    "reports": []
                },
                {
                    "app_id": "csv_parser",
                    "routeUrl": "p/csv-parser",
                    "app_name": "CSV Parser",
                    "app_description": "",
                    "app_bg_image": "assets/images/apps/logbook.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/#/p/visualization/visualization_101",
                    "app_name": "Machine Fault Prediction",
                    "app_description": "Artificial Intelligence based Hydrolic Motor Failure Event Prediction",
                    "app_bg_image": "assets/images/more-apps/machine-fault-prediction.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/#/p/visualization/visualization_106",
                    "app_name": "Anomaly Detection",
                    "app_description": "Artificial Intelligence based Anomaly detection",
                    "app_bg_image": "assets/images/more-apps/anomaly-detection.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/ppe",
                    "app_name": "Personal Protective Equipment",
                    "app_description": "Artificial Intelligence based PPE",
                    "app_bg_image": "assets/images/more-apps/ppe.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://ai.ilens.io/flare-ui/#/login",
                    "app_name": "Flare Monitoring",
                    "app_description": "Artificial Intelligence based Flare Monitoring",
                    "app_bg_image": "assets/images/more-apps/flare-detection.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/intrusion-detection",
                    "app_name": "Intrusion Detection",
                    "app_description": "Artificial Intelligence based Intrusion Detection",
                    "app_bg_image": "assets/images/more-apps/intrusion-detection.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/attendance-management",
                    "app_name": "Attendance Management",
                    "app_description": "Face Recognition based Attendance Management",
                    "app_bg_image": "assets/images/more-apps/attendance-mgmt.png",
                    "reports": [],
                    "disabled": True
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Object Detection",
                    "app_description": "Artificial Intelligence based Object Detection",
                    "app_bg_image": "assets/images/more-apps/object-detection.png",
                    "reports": [],
                    "disabled": True
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Cookie Vision System",
                    "app_description": "Artificial Intelligence based Cookie Vision System",
                    "app_bg_image": "assets/images/more-apps/biscuitimage.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Label Detection",
                    "app_description": "Artificial Intelligence based label detection",
                    "app_bg_image": "assets/images/more-apps/face-recognition.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Number Plate Detection",
                    "app_description": "Artificial Intelligence based Number Plate Detection",
                    "app_bg_image": "assets/images/more-apps/number-plate-detection.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Face Detection",
                    "app_description": "Artificial Intelligence based face detection",
                    "app_bg_image": "assets/images/more-apps/face-recognition.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Text Translation",
                    "app_description": "Artificial Intelligence based Text Translation",
                    "app_bg_image": "assets/images/more-apps/text-translation.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://staging.ilens.io/ilens-manager/#/p/apps/object-detection",
                    "app_name": "Pose Detection",
                    "app_description": "Artificial Intelligence based pose detection",
                    "app_bg_image": "assets/images/more-apps/ppe.png",
                    "reports": []
                }
            ]
        },
        {
            "label": "Customized Apps",
            "items": [
                {
                    "app_id": "pnp",
                    "app_url": "https://azr-wab-hrbot.azurewebsites.net/",
                    "app_name": "HR Bot",
                    "app_description": "NLP and computer vision powered HR bot that let's user update documents",
                    "app_bg_image": "assets/images/more-apps/hr.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://fslbot-v1.azurewebsites.net/",
                    "app_name": "Payment Portal",
                    "app_description": "NLP powered bot for health and insurance sector",
                    "app_bg_image": "assets/images/more-apps/health-insurance.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://azr-wab-glensbot.azurewebsites.net/",
                    "app_name": "Customer Support Bot",
                    "app_description": "NLP powered bot for automation of ticket creation, tracking and resolution",
                    "app_bg_image": "assets/images/more-apps/customer-support.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "disabled": True,
                    "app_url": "https://azr-wab-glensbot.azurewebsites.net/",
                    "app_name": "Conversation BI",
                    "app_description": "NLP powered assistant for BI dashboards",
                    "app_bg_image": "assets/images/more-apps/powerbi-assistant.png",
                    "reports": []
                },
                {
                    "app_id": "pnp",
                    "app_url": "https://pnp.ilens.io",
                    "app_name": "Pick & Place",
                    "app_description": "iLens provides an all-encompassing framework to develop the PnP Nozzle Monitoring product.",
                    "app_bg_image": "assets/images/apps/pnp.png",
                    "reports": []
                }
            ]
        },
        {
            "label": "Embedded Apps",
            "items": [
                {
                    "app_id": "app_2",
                    "app_name": "Inventory Management",
                    "app_description": "Inventory Analytics by Item, Warehouse and Consumption",
                    "app_bg_image": "assets/images/app-studio-images/inventory-management-img.jpg",
                    "reports": [
                        {
                            "report_id": "report_4",
                            "report_name": "Inventory Trend by value",
                            "report_description": "Inventory Trend by value",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiMzdkNTEzNzAtZjliOS00ZWUyLTgxMjQtN2Y5ZmFmMjczZjUwIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_5",
                            "report_name": "Stock in Hand Over Days",
                            "report_description": "Stock in Hand Over Days",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiZWQ2ZmZlYjEtMDljNy00NjhhLTk4MWYtZmM4NmNiOTQ2OGNlIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_6",
                            "report_name": "Inventory by Warehouse",
                            "report_description": "Inventory by Warehouse",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiZDNlNDkwNzMtZTJjMS00ZWI5LWJkOTctNjk1M2FiMzczNWEzIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_12",
                            "report_name": "Inventory by Item",
                            "report_description": "Inventory by Warehouse",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiMzk5NzVlYzEtNjU3MS00MTdkLTk3NjgtMDhkY2E1MGIxYWQxIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_13",
                            "report_name": "Inventory - NOD",
                            "report_description": "Inventory by Warehouse",
                            "report_url": " https://app.powerbi.com/view?r=eyJrIjoiMTI1YmNjYWEtNTUwNy00MTIxLWJhZjItYWYzYjI5NjFkOTRjIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        }
                    ]
                },
                {
                    "app_id": "app_3",
                    "app_name": "Cost Management",
                    "app_description": "Analytics related to COGM, COGS, Days on Hand and Turnover",
                    "app_bg_image": "assets/images/app-studio-images/cost.png",
                    "reports": [
                        {
                            "report_id": "report_9",
                            "report_name": "Variance in cost (Planned vs Actual)",
                            "report_description": "Variance (Planned vs Actual)",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiOGY3NTRkZTAtZmY4MS00NDI0LTgzMDctNmQxYWY3MjcyMWJiIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_7",
                            "report_name": "Production Trend",
                            "report_description": "Production Trend",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiZjFmNTM1NmQtZWRiOS00ZmY3LThhM2QtNWRmZDY3MjgyY2RmIiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_8",
                            "report_name": "COGM by Date",
                            "report_description": "COGM by Date",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiMzRjNGM4NTYtYmJmZC00ZmY3LWE4NTktYjU1ZmI5N2VkNWE0IiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        },
                        {
                            "report_id": "report_11",
                            "report_name": "Purchase Trend",
                            "report_description": "Purchase Trend",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiNGYyNmQyNDQtMTQyOS00YTNiLTgzZjQtNzA5MGQ4MjQwYzk2IiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        }
                    ]
                },
                {
                    "app_id": "app_4",
                    "app_name": "Energy Management",
                    "app_description": "Analytics on Energy Usage and Anomalies",
                    "app_bg_image": "assets/images/app-studio-images/energy.png",
                    "reports": [
                        {
                            "report_id": "report_10",
                            "report_name": "Energy Consumed by Date",
                            "report_description": "Energy Consumed by Date",
                            "report_url": "https://app.powerbi.com/view?r=eyJrIjoiNzIzYTI5NGItYzQ2ZC00NWYzLTg0YWQtNmY5N2RkNzQ5ZjY2IiwidCI6IjBlMGRiMmFkLWM0MTYtNDdjNy04OGVjLWNlYWM0ZWU3Njc2NyIsImMiOjEwfQ%3D%3D"
                        }
                    ]
                }
            ]
        }
    ]
    mqtt_details_json = {"username": "biswajit", "password": "admin"}
    types_json_for_apps = [
        {
            "label": "Native",
            "value": "native"
        },
        {
            "label": "Customized",
            "value": "customized"
        },
        {
            "label": "Embedded",
            "value": "embedded"
        }
    ]
    apps_header_content = [
        {
            "label": "App Name",
            "value": "name"
        },
        {
            "label": "Description",
            "value": "description"
        },
        {
            "label": "Type",
            "value": "typeLabel"
        },
        {
            "label": "Category",
            "value": "category"
        },

        {
            "action": {
                "type": "status_change"
            },
            "enableClick": True,
            "iconClass": "starred-status",
            "inLineStye": {
                "cursor": "pointer",
                "max-width": "100px",
                "text-align": "center",
                "vertical-align": "middle",
                "width": "100px"
            },
            "label": "Starred",
            "no_label": True,
            "type": "icon",
            "value": "starred"
        }

    ]


# Uploaded CSV file details
UPLOAD_CSV_FILE_PATH = "conf"

SERVER_KEY_FILE_PATH = "keys/server.key"
LICENSE_KEY_FILE_PATH = "keys/license.key"
INIT_KEY_FILE_PATH = "keys/init.key"

symm_enc_key = '''
-----BEGIN PRIVATE KEY-----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-----END PRIVATE KEY-----
'''
