import os
import yaml
import logging
from yolov7processor import YoloV7Processor
from videos_to_frames_file_rename import convert_video_to_frames, rename_files_in_folder

if __name__ == '__main__':
    # Load configuration from YAML file
    with open('config.yaml', 'r') as f:
        config = yaml.safe_load(f)

    # Extract parameters from configuration
    video_path = config['video_path']
    frame_skip = config['frame_skip']
    output_path = config.get('output_path')
    string_to_add = config['string_to_add']
    source = config['source']
    weights = config['weights']
    imgsz = config['imgsz']
    trace = config['trace']
    target_dir = config['target_dir']

    if output_path and not os.path.exists(output_path):
        os.makedirs(output_path)          

    # Convert video to frames
    logging.info("Converting to frames............")
    output_directory = convert_video_to_frames(video_path, frame_skip, output_path)
    logging.info("Videos to frames conversion complete!")


    if output_directory:
        # Rename files in output directory    
        logging.info("Renaming files.......")    
        rename_files_in_folder(output_directory, string_to_add)
        logging.info("Files renaming complete!")
    
    #detect = YoloV7Processor(source =r'D:\JK_Data\videos\new_Data\camera_46\2023-03-26_05-12-30_5', weights =r'D:\JK_Data\yolov7-tiny-v5\weights\jk_v5.pt', imgsz = 416, trace = True, target_dir=r'D:\JK_Data\videos\new_Data\camera_46\2023-03-26_05-12-30_5')
    logging.info("Running YoloV7Processor...")
    detect = YoloV7Processor(source=source, weights=weights, imgsz=imgsz, trace=trace, target_dir=target_dir)
    detect.detect()
    logging.info("YoloV7Processor finished.")