import pandas as pd
from formiodata import form

from scripts.logging.logging import logger


def parse_component(component_json, given_key, required_key):
    """Usage: print(parse_component(component_json, 'textField', "label"))"""
    builder = form.Builder(component_json)
    key_content = getattr(builder, "input_components").get(given_key)
    return getattr(key_content, required_key)


def get_field_props(form_props, search_keys, value):
    """Pass custom properties dict and get a dictionary matching those conditions"""
    if not isinstance(search_keys, list):
        search_keys = [search_keys]
    props = pd.DataFrame.from_dict(form_props, orient='index')
    if not all([not props.empty, set(search_keys).intersection(set(props.columns))]):
        return dict()
    try:
        new_df = props[props[search_keys[0]] == value]
    except KeyError:
        new_df = props[props[search_keys[1]] == value]
    return new_df.to_dict(orient='index')


def check_required(key, component_json):
    builder = form.Builder(component_json)
    key_content = getattr(builder, "input_components").get(key)
    if not key_content:
        logger.debug(f"{key} not present in component, skipping required fields check..")
        return False
    is_required = bool(getattr(key_content, "required"))
    return is_required


def get_field_props_by_keys(form_props, search_keys):
    """Pass custom properties dict and get a dictionary matching those conditions"""
    if not isinstance(search_keys, list):
        search_keys = [search_keys]
    props = pd.DataFrame.from_dict(form_props, orient='index')
    if not all([not props.empty, set(search_keys).intersection(set(props.columns))]):
        return dict()
    if len(search_keys) > 1:
        new_df = props.get(search_keys[0], props.get(search_keys[-1]))
    else:
        new_df = props.get(search_keys[0])
    new_df.dropna(inplace=True)
    return new_df.to_dict()


def get_form_component_info(component_json, required_key):
    builder = form.Builder(component_json)
    return getattr(builder, required_key)
