from typing import List

import pandas as pd

from scripts.logging.logging import logger
from scripts.utils.common_utils import CommonUtils


class ProcessData:
    def __init__(self, project_id=None):
        self.common_utils = CommonUtils(project_id=project_id)

    @staticmethod
    def round_off(dfs, column_of_values):
        try:
            dfs[column_of_values] = dfs[column_of_values].astype('float64', errors='ignore')
            dfs[column_of_values] = dfs[column_of_values].apply(
                lambda row: round(row, 2) if isinstance(row, (int, float)) else row)
            return dfs
        except Exception as e:
            logger.exception("Error occurred while rounding DF", {e})
            return dfs

    @staticmethod
    def merge_with_another_df(df_1, df_2, merge_on: List):
        try:
            dfs = df_1.merge(df_2, on=merge_on, how='inner').fillna("-")
            return dfs
        except Exception as e:
            logger.exception("Error occurred while merging DFs", {e})
            raise

    def convert_series_format(self, series, tz, in_format):
        return series.apply(
            lambda row: self.common_utils.time_zone_converter(row, tz, in_format))

    def add_timestamp_to_df(self, df, date, tz, from_format):
        if "time" not in df.columns:
            return pd.Series(dtype=int)
        df = df[df['time'].notna()]
        date_series = df.apply(
            lambda row: self.common_utils.convert_str_to_ts(date, row["time"], from_format, tz), axis=1)
        return date_series
