from sqlalchemy import create_engine, inspect
from sqlalchemy.orm import Session

from scripts.config.app_configurations import DBConf
from scripts.db.psql.models.gen_std_norm import DBModelGenStdNorm, GenStdNormSchema
from scripts.logging.logging import logging_config, logger


class QueryLayer:
    def __init__(self, db: Session):
        self.session: Session = db
        self.echo = logging_config["level"].upper() == "DEBUG"
        self.table_obj = DBModelGenStdNorm
        self.create_table(self.table_obj)

    def create_table(self, table):
        try:
            engine = create_engine(DBConf.ASSISTANT_DB_URI, echo=self.echo)
            if not inspect(engine).has_table(table.__tablename__):
                orm_table = table
                orm_table.__table__.create(bind=engine, checkfirst=True)
        except Exception as e:
            logger.error(f"Error occurred during start-up: {e}", exc_info=True)

    @property
    def column_id(self):
        return "id"

    def add_to_table(self, records, step_id, date):
        list_of_recs = list()
        try:
            for each in records:
                summary_obj = GenStdNormSchema(**each).dict(exclude_none=True)
                table_obj = self.table_obj(**summary_obj)
                list_of_recs.append(table_obj)
            return list_of_recs
        except Exception as e:
            logger.exception(f"Exception occurred while adding to postgres table {self.table_obj.__tablename__} {e}")

    def insert_data(self, object_models_list, step_id, date):
        try:
            self.delete_data()
            mappings = self.add_to_table(object_models_list, step_id, date)
            self.session.bulk_save_objects(mappings)
            self.session.commit()
            return True
        except TypeError:
            raise
        except Exception as e:
            logger.exception(e)
            raise

    def delete_data(self):
        try:
            self.session.query(self.table_obj).delete()
            self.session.commit()
            return True
        except Exception as e:
            logger.error(f"Failed to delete existing data, {e}")
            raise
