from pydantic import BaseModel
from sqlalchemy import Column, Integer, Float

from scripts.db.psql.databases import Base
from . import none_or_float


class DBModelUtilStdNorm(Base):
    __tablename__ = "util_std_norm"
    id = Column(Integer, autoincrement=True, primary_key=True)
    dfg_generation = Column(Float, nullable=True)
    power_consumption = Column(Float, nullable=True)
    power_actualconsumption = Column(Float, nullable=True)
    power_yield = Column(Float, nullable=True)
    steam_consumption = Column(Float, nullable=True)
    steam_actualconsumption = Column(Float, nullable=True)
    steam_yield = Column(Float, nullable=True)
    nitrogen_consumption = Column(Float, nullable=True)
    nitrogen_actualconsumption = Column(Float, nullable=True)
    nitrogen_yield = Column(Float, nullable=True)
    ng_consumption = Column(Float, nullable=True)
    ng_actualconsumption = Column(Float, nullable=True)
    ng_yield = Column(Float, nullable=True)
    water_consumption = Column(Float, nullable=True)
    water_actualconsumption = Column(Float, nullable=True)
    water_yield = Column(Float, nullable=True)
    condensate_generation_consumption = Column(Float, nullable=True)
    condensate_generation_actualconsumption = Column(Float, nullable=True)
    condensate_generation_yield = Column(Float, nullable=True)


class UtilStdNormSchema(BaseModel):
    dfg_generation: none_or_float
    power_consumption: none_or_float
    power_actualconsumption: none_or_float
    power_yield: none_or_float
    steam_consumption: none_or_float
    steam_actualconsumption: none_or_float
    steam_yield: none_or_float
    nitrogen_consumption: none_or_float
    nitrogen_actualconsumption: none_or_float
    nitrogen_yield: none_or_float
    ng_consumption: none_or_float
    ng_actualconsumption: none_or_float
    ng_yield: none_or_float
    water_consumption: none_or_float
    water_actualconsumption: none_or_float
    water_yield: none_or_float
    condensate_generation_consumption: none_or_float
    condensate_generation_actualconsumption: none_or_float
    condensate_generation_yield: none_or_float
