from pydantic.main import BaseModel
from sqlalchemy import Column, Integer, String

from scripts.db.psql.databases import Base
from scripts.db.psql.models.ope_formula_calculation import none_or_float


class DBModelMaster(Base):
    __tablename__ = "oee_master_table"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    batch_size = Column(Integer, nullable=True)
    bct = Column(Integer, nullable=True)
    c_div_t = Column(Integer, nullable=True)


class MasterTableSchema(BaseModel):
    batch_size: none_or_float
    bct: none_or_float
    c_div_t: none_or_float
