from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base
from scripts.db.psql.models.ope_formula_calculation import none_or_float


class DBModelDailyProduction(Base):
    __tablename__ = "oee_daily_production"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    output = Column(Float, nullable=True)
    rework = Column(Float, nullable=True)
    defect = Column(Float, nullable=True)
    shift_incharge = Column(String, nullable=True)


class DailyProductionSchema(BaseModel):
    output: none_or_float
    rework: none_or_float
    defect: none_or_float
    shift_incharge: none_or_float
