from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Float

from scripts.db.psql.databases import Base
from scripts.db.psql.models.ope_formula_calculation import none_or_float


class DBModelMTDOEESummary(Base):
    __tablename__ = "mtd_oee_summary"
    id = Column(Integer, autoincrement=True, primary_key=True)
    date = Column(String)
    step_id = Column(String)
    capacity_mtd = Column(Float, nullable=True)
    total_time_mtd = Column(Float, nullable=True)
    available_time_mtd = Column(Float, nullable=True)
    total_production_good_mtd = Column(Float, nullable=True)
    total_production_bad_mtd = Column(Float, nullable=True)
    availability_mtd = Column(Float, nullable=True)
    performance_mtd = Column(Float, nullable=True)
    quality_mtd = Column(Float, nullable=True)
    ope_mtd = Column(Float, nullable=True)
    oee_net_available_time_mtd = Column(Float, nullable=True)
    oee_planned_time_mtd = Column(Float, nullable=True)
    oee_availability_mtd = Column(Float, nullable=True)
    oee_performance_mtd = Column(Float, nullable=True)
    oee_quality_mtd = Column(Float, nullable=True)
    oee_mtd = Column(Float, nullable=True)
    oee_ytd_target = Column(Float, nullable=True)


class MTDOEESummarySchema(BaseModel):
    capacity_mtd: none_or_float
    total_time_mtd: none_or_float
    available_time_mtd: none_or_float
    total_production_good_mtd: none_or_float
    total_production_bad_mtd: none_or_float
    availability_mtd: none_or_float
    performance_mtd: none_or_float
    quality_mtd: none_or_float
    ope_mtd: none_or_float
    oee_net_available_time_mtd: none_or_float
    oee_planned_time_mtd: none_or_float
    oee_availability_mtd: none_or_float
    oee_performance_mtd: none_or_float
    oee_quality_mtd: none_or_float
    oee_mtd: none_or_float
    oee_ytd_target: none_or_float
