from sqlalchemy import create_engine
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from sqlalchemy_utils import database_exists, create_database

from scripts.config.app_configurations import DBConf

maintenance_engine = create_engine(DBConf.MAINTENANCE_DB_URI)
if not database_exists(maintenance_engine.url):
    create_database(maintenance_engine.url)
assistant_engine = create_engine(DBConf.ASSISTANT_DB_URI)
if not database_exists(assistant_engine.url):
    create_database(assistant_engine.url)

maintenance_session = sessionmaker(autocommit=False, autoflush=False, bind=maintenance_engine)
assistant_session = sessionmaker(autocommit=False, autoflush=False, bind=assistant_engine)

Base = declarative_base()


# Dependency
def get_db():
    db = maintenance_session()
    try:
        yield db
    finally:
        db.close()


def get_assistant_db():
    db = assistant_session()
    try:
        yield db
    finally:
        db.close()
