from typing import Optional, List

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import TagKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class TagSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    tag_name: Optional[str]
    unit: Optional[str]
    tag_type: Optional[str]
    description: Optional[str]
    id: Optional[str]
    tag_group_id: Optional[str]
    data_type: Optional[float]
    default: Optional[bool]
    system_tag_type: Optional[str]
    tag_category_id: Optional[str]
    value_list: Optional[List]
    product_encrypted: Optional[bool]


class Tag(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_configuration,
                         collection=CollectionNames.tags)
        self.project_id = project_id

    @property
    def key_tag_id(self):
        return TagKeys.KEY_TAG_ID

    @property
    def key_tag_name(self):
        return TagKeys.KEY_TAG_NAME

    def find_name_by_id(self, tag_id: str):
        query = {self.key_tag_id: tag_id}
        filter_dict = {self.key_tag_name: 1, "_id": 0}
        record = self.find_one(query, filter_dict)
        if not record:
            return None
        return record[self.key_tag_name]
