class UserRoleAggregate:

    @staticmethod
    def get_user_roles_list(project_id: str):
        query_json = [{
            "$match": {
                "project_id": project_id
            }}, {'$group': {'_id': None, 'data': {
            '$push': {'k': {'$ifNull': ['$user_role_id', '']}, 'v': {'$ifNull': ['$user_role_name', '']}}}}},
            {'$replaceRoot': {'newRoot': {'$arrayToObject': '$data'}}}]
        return query_json

    @staticmethod
    def user_roles_list_key_value_pairs(project_id: str, user_roles: list = None):
        query_dict = dict()
        query_dict.update(project_id=project_id)
        if bool(user_roles):
            query_dict.update({
                "user_role_id": {"$in": user_roles}
            })
        query_json = [{
            "$match": query_dict}, {'$project': {'_id': 0,
                                                 'value': {'$ifNull': ['$user_role_id', '']},
                                                 'label': {'$ifNull': ['$user_role_name', '']}}}]
        return query_json
