class SiteConfAggregate:
    @staticmethod
    def get_site_list_key_value(project_id: str):
        query_json = [
            {
                '$match': {
                    'customer_project_id': project_id
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            'k': '$site_id',
                            'v': '$$ROOT'
                        }
                    }
                }
            }, {
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            }
        ]
        return query_json