class IlensConfigMobileMongoQueries:
    @staticmethod
    def site_hierarchy(project_id: str):
        query_json = [
            {'$match': {
                'customer_project_id': project_id
            }},
            {"$project":
                {
                    "_id": 0,
                    "value": "$site_name",
                    "id": "$site_id"
                }}
        ]
        return query_json

    @staticmethod
    def fetch_level_one_hierarchy_details(site_id: str, hierarchy_type):
        query_json = [
            {'$match': {'site_id': site_id}}, {
                '$unwind': {
                    'path': f'${hierarchy_type}'
                }
            }, {
                '$group': {
                    "_id": None,
                    'data': {"$push": {
                        'value': f'${hierarchy_type}.{hierarchy_type}_name',
                        'id': {
                            '$concat': ["$site_id", {"$literal": "$"}, f'${hierarchy_type}.{hierarchy_type}_id']}
                    }}
                }}]
        return query_json

    @staticmethod
    def fetch_level_two_hierarchy_details(site_id: str, hierarchy_id: str, hierarchy_type: str, concat_list: list):
        query_hierarchy_type = hierarchy_id.split("_")[0]
        query_json = [
            {
                '$match': {
                    'site_id': site_id
                }
            }, {
                '$unwind': {
                    'path': f'${hierarchy_type}'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            '$cond': [
                                {
                                    '$eq': [
                                        hierarchy_id, f'${hierarchy_type}.{query_hierarchy_type}_id'
                                    ]
                                }, {
                                    'value': f'${hierarchy_type}.{hierarchy_type}_name',
                                    'id': {"$concat": concat_list}
                                }, '$$REMOVE'
                            ]
                        }
                    }
                }
            }]
        return query_json
