class ConfigAggregate:

    @staticmethod
    def get_project_template(project_id: str):
        query_json = [
            {
                '$match': {
                    'customer_project_id': project_id
                }
            }, {
                '$addFields': {
                    'site_template': 'site_template'
                }
            }, {
                '$lookup': {
                    'from': 'constants',
                    'localField': 'site_template',
                    'foreignField': 'type',
                    'as': 'data'
                }
            }, {
                '$unwind': {
                    'path': '$data'
                }
            }, {
                '$unwind': {
                    'path': '$data.data'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            '$cond': {
                                'if': {
                                    '$eq': [
                                        '$site_templt_id', '$data.data.site_templt_id'
                                    ]
                                },
                                'then': '$data.data.key_list',
                                'else': '$$REMOVE'
                            }
                        }
                    }
                }
            }, {
                '$project': {
                    '_id': 0,
                    'data': {
                        '$ifNull': [
                            {
                                '$arrayElemAt': [
                                    '$data', 0
                                ]
                            }, False
                        ]
                    }
                }
            }
        ]
        return query_json

    @staticmethod
    def site_hierarchy(project_id: str):
        query_json = [
            {'$match': {
                'customer_project_id': project_id
            }},
            {"$project":
                {
                    "_id": 0,
                    "label": "$site_name",
                    "value": "$site_id",
                    "hierarchy_id": "$site_id"
                }}
        ]
        return query_json

    @staticmethod
    def get_site_hierarchy(project_id: str, path: str, label_query: list, value_query: list,
                           add_fields={}):
        query_json = [
            {
                '$match': {
                    'customer_project_id': project_id
                }
            }, {
                '$unwind': {
                    'path': f'${path}'
                }
            },
            {
                '$addFields': add_fields
            },
            {
                '$group': {
                    '_id': {
                        'label': {
                            '$concat': label_query
                        },
                        'value': {
                            '$concat': value_query
                        }
                    }
                }
            },
            {
                '$replaceRoot': {
                    'newRoot': '$_id'
                }
            }
        ]
        if not bool(add_fields):
            query_json.pop(2)
        return query_json

    @staticmethod
    def fetch_level_one_hierarchy_details(site_id: str, hierarchy_type, fun_type=False):
        query_json = [
            {'$match': {'site_id': site_id}}, {
                '$unwind': {
                    'path': f'${hierarchy_type}'
                }
            }, {
                '$group': {
                    "_id": None,
                    'data': {"$push": {
                        'label': f'${hierarchy_type}.{hierarchy_type}_name',
                        "hierarchy_id": f'${hierarchy_type}.{hierarchy_type}_id',
                        'value': {
                            '$concat': ["$site_id", {"$literal": "$"}, f'${hierarchy_type}.{hierarchy_type}_id']}
                    }}
                }}]
        if fun_type:
            query_json.pop()
            query_json.append({
                '$group': {
                    "_id": None,
                    'data': {"$push": {
                        'k': {'$ifNull': [f'${hierarchy_type}.{hierarchy_type}_name', ""]},
                        'v': {'$ifNull': [{
                            '$concat': ["$site_id", {"$literal": "$"}, f'${hierarchy_type}.{hierarchy_type}_id']}, ""]
                        }}
                    }}})
            query_json.append({
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }
            })
        return query_json

    @staticmethod
    def fetch_level_two_hierarchy_details(site_id: str, hierarchy_id: str, hierarchy_type: str, concat_list: list,
                                          fun_type=False):
        query_hierarchy_type = hierarchy_id.split("_")[0]
        query_json = [
            {
                '$match': {
                    'site_id': site_id
                }
            }, {
                '$unwind': {
                    'path': f'${hierarchy_type}'
                }
            }, {
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            '$cond': [
                                {
                                    '$eq': [
                                        hierarchy_id, f'${hierarchy_type}.{query_hierarchy_type}_id'
                                    ]
                                }, {
                                    'label': f'${hierarchy_type}.{hierarchy_type}_name',
                                    'hierarchy_id': f'${hierarchy_type}.{hierarchy_type}_id',
                                    'value': {"$concat": concat_list}
                                }, '$$REMOVE'
                            ]
                        }
                    }
                }
            }]
        if fun_type:
            query_json.pop()
            query_json.append({
                '$group': {
                    '_id': None,
                    'data': {
                        '$push': {
                            '$cond': [
                                {
                                    '$eq': [
                                        hierarchy_id, f'${hierarchy_type}.{query_hierarchy_type}_id'
                                    ]
                                }, {
                                    'k': {'$ifNull': [f'${hierarchy_type}.{hierarchy_type}_name', ""]},
                                    'v': {"$concat": concat_list}
                                }, '$$REMOVE'
                            ]
                        }
                    }
                }
            })
            query_json.append({
                '$replaceRoot': {
                    'newRoot': {
                        '$arrayToObject': '$data'
                    }
                }})

        return query_json

    @staticmethod
    def list_logbook_info():
        query_json = [
            {
                '$match': {}
            },
            {
                '$project': {
                    '_id': 0,
                    'project_id': '$project_id',
                    'logbook_id': '$logbook_id',
                    'created_on': '$meta.created_at',
                    'created_by': '$meta.created_by',
                    'logbook_name': '$logbook_name',
                    'logbook_description': '$logbook_description',
                    'logbook_type': '$logbook_type',
                    'workflow_spec_id': "$workflow_spec_id",
                    'hierarchy': '$hierarchy'
                }
            }
        ]
        return query_json
