from typing import Optional

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import WorkflowKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class PermissionsWorkflowSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    workflow_id: Optional[str]
    workflow_version: Optional[str]
    workflow_status: Optional[str]
    user_role: Optional[str]
    step_id: Optional[str]
    permissions: Optional[list] = []
    sequence_no: Optional[int]


class Permissions(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.workflow_permissions)
        self.project_id = project_id

    @property
    def key_workflow_id(self):
        return WorkflowKeys.KEY_WORKFLOW_ID

    @property
    def key_workflow_version(self):
        return WorkflowKeys.KEY_WORKFLOW_VERSION

    def update_permission(self, workflow_id, data: dict, upsert=False):
        query = {self.key_workflow_id: workflow_id}
        return self.update_one(data=data, query=query, upsert=upsert)

    def add_new_permission(self, data: dict):
        data = PermissionsWorkflowSchema(**data).dict()
        self.insert_one(data)
        return PermissionsWorkflowSchema(**data).workflow_id

    def soft_delete_permission(self, workflow_id):
        json_update = {"is_deleted": True}
        query = {self.key_workflow_id: workflow_id}
        return self.update_one(data=json_update, query=query)

    def find_by_id(self, workflow_id: str):
        query = {self.key_workflow_id: workflow_id}
        record = self.find_one(query)
        if not record:
            return None
        return PermissionsWorkflowSchema(**record)

    def find_all_permissions(self, workflow_id, workflow_version):
        query = {self.key_workflow_id: workflow_id,
                 self.key_workflow_version: workflow_version}
        records = self.find(query=query)
        if not records:
            return None
        return records

    def get_data_by_aggregate(self, query_json: list):
        return list(self.aggregate(query_json))
