from typing import Optional, List

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import ProjectRemarksKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class ProjectRemarksSchema(MongoBaseSchema):
    project_id: Optional[str] = None
    remarks: Optional[List] = None


class ProjectRemarks(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.project_remarks)
        self.project_id = project_id

    @property
    def key_project_id(self):
        return ProjectRemarksKeys.KEY_PROJECT_ID

    @property
    def key_remarks(self):
        return ProjectRemarksKeys.Key_REMARKS

    def find_by_id(self, project_id: str):
        query = {self.key_project_id: project_id}
        record = self.find_one(query)
        if not record:
            return None
        return record

    def update_project_info(self, project_id, data, upsert=False):
        query = {self.key_project_id: project_id}
        json_data = {self.key_remarks: data}
        return self.update_one(data=json_data, query=query, upsert=upsert)
