from typing import Optional, List

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class LogbookLinkSchema(MongoBaseSchema):
    logbook_id: Optional[str]
    external_links: Optional[List] = []
    is_deleted: Optional[bool]


class LogbookLinkInfo(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_assistant,
                         collection=CollectionNames.logbook_links)
        self.project_id = project_id

    def find_by_logbook_id(self, logbook_id):
        query = {"logbook_id": logbook_id}
        record = self.find_one(query)
        if not record:
            return LogbookLinkSchema(**dict())
        return LogbookLinkSchema(**record)
