from typing import Optional, List, Dict

from scripts.constants.app_constants import DatabaseNames, CollectionNames
from scripts.constants.db_keys import AssetDetailsKeys
from scripts.db.mongo.schema import MongoBaseSchema
from scripts.utils.mongo_util import MongoCollectionBaseClass


class AssetDetailSchema(MongoBaseSchema):
    """
    This is the Schema for the Mongo DB Collection.
    All datastore and general responses will be following the schema.
    """
    asset_model_id: Optional[str]
    allow_editing: Optional[bool] = True
    asset_description: Optional[str]
    asset_version: Optional[str]
    asset_model_name: Optional[str]
    asset_model_type: Optional[str]
    asset_model_icon: Optional[str]
    parameters: Optional[Dict] = dict()
    parameters_new: Optional[Dict] = dict()
    processes: Optional[list] = list()
    device_models: Optional[List] = list()
    events: Optional[List] = list()
    resources: Optional[Dict] = dict()
    others: Optional[Dict] = dict()


class AssetDetail(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(mongo_client, database=DatabaseNames.ilens_asset_model,
                         collection=CollectionNames.asset_model_details)
        self.project_id = project_id

    @property
    def key_project_id(self):
        return AssetDetailsKeys.KEY_PROJECT_ID

    @property
    def key_asset_model_id(self):
        return AssetDetailsKeys.KEY_ASSET_MODEL_ID

    @property
    def key_asset_version(self):
        return AssetDetailsKeys.KEY_ASSET_VERSION

    @property
    def key_asset_model_name(self):
        return AssetDetailsKeys.KEY_ASSET_MODEL_NAME

    def find_asset_detail_by_id(self, asset_id, asset_version, filter_dict=None):
        query = dict()
        if asset_id:
            query.update({self.key_asset_model_id: asset_id})
        if asset_version:
            query.update({self.key_asset_version: asset_version})
        asset_data = self.find_one(query=query, filter_dict=filter_dict)
        if asset_data:
            return asset_data
        return dict()
