import traceback

from fastapi import APIRouter, Depends

from scripts.constants.api import CommentsEndPoints
from scripts.core.handlers.comments_handler import CommentHandler
from scripts.core.schemas.comments import TagList
from scripts.core.schemas.response_models import DefaultResponse, DefaultFailureResponse
from scripts.logging.logging import logger
from scripts.utils.security_utils.decorators import CookieAuthentication
from scripts.utils.security_utils.project_decorator import MetaInfoCookie, MetaInfoSchema

auth = CookieAuthentication()
comment_router = APIRouter(tags=["Stage services"], prefix=CommentsEndPoints.api_comment)
get_cookies = MetaInfoCookie()


@comment_router.post(CommentsEndPoints.api_list)
async def get_tags_comments(request_data: TagList, meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        comment_handler = CommentHandler(project_id=meta.project_id)
        response = comment_handler.get_tags_list(request_data)
        return DefaultResponse(status="success", message="success", data=response).dict()
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultFailureResponse(error=e.args, message=e.args).dict()
