from typing import Optional, List, Dict

from pydantic import BaseModel


class CreateTemplate(BaseModel):
    pass


class TemplateListResponse(BaseModel):
    bodyContent: Optional[List] = []
    total_no: Optional[int]
    endOfRecords: Optional[bool] = False


class UploadedFileListResponse(BaseModel):
    bodyContent: Optional[List] = []
    total_no: Optional[int]
    endOfRecords: Optional[bool] = False


class TemplateListRequest(BaseModel):
    startRow: Optional[int]
    endRow: Optional[int]
    filters: Optional[Dict]
    project_id: Optional[str]
    timezone: Optional[str] = "Asia/Kolkata"


class TemplateTableOptions(BaseModel):
    project_id: Optional[str]
    type: Optional[str]


class TemplateKeyValuePairs(BaseModel):
    project_id: str
    logbook_id: str
    associated_workflow_version: int


class DeleteTemplate(BaseModel):
    template_id: str
    project_id: Optional[str]


class DeleteDataFile(BaseModel):
    file_id: str
    project_id: Optional[str]


class FetchTemplate(BaseModel):
    template_id: str
    project_id: str


class UploadedFileList(BaseModel):
    startRow: Optional[int]
    endRow: Optional[int]
    filters: Optional[Dict]
    project_id: Optional[str]
    timezone: Optional[str] = "Asia/Kolkata"
