from typing import Optional, Dict, Any

from pydantic import BaseModel

from scripts.constants.app_constants import SubmitAction


class StagesList(BaseModel):
    task_id: str
    workflow_id: str
    task_status: str
    workflow_version: int
    project_id: str
    mobile: Optional[bool] = False


class GetKDataRequest(BaseModel):
    step_id: str
    values: Dict
    ts: int
    time_str: Optional[str]
    metadata: Optional[Dict] = dict()
    tz: str = "Asia/Kolkata"


class SaveRemarks(BaseModel):
    project_id: str
    comment: Optional[str]
    stage_id: Optional[str]
    subject: Optional[str]
    user_id: Optional[str]
    user_name: Optional[str]
    updated_on: Optional[str]
    type: Optional[str]
    parameter_specific: Optional[Dict] = dict()


class FetchRemarks(BaseModel):
    stage_id: Optional[str]
    project_id: str
    timezone: Optional[str] = "Asia/Kolkata"


class GetTagsRequest(BaseModel):
    step_id: str


class TriggerData(BaseModel):
    trigger_time: Optional[int]
    step_id: str
    manual_entry: Optional[bool] = False
    tz: str = "Asia/Kolkata"
    trigger_method: str
    status: Optional[int] = 1
    tag_id: Optional[str]
    from_time: Optional[int]
    to_time: Optional[int]


class TriggerReferenceData(BaseModel):
    project_id: Optional[str]
    user_id: Optional[str]
    stage_id: Optional[str]
    submitted_data: Optional[Dict] = dict()
    type: Optional[str] = SubmitAction.save
    current_status: Optional[str]
    task_id: Optional[str]
    tz: Optional[str] = "Asia/Kolkata"
    triggers: Optional[Dict] = dict()
    date: Optional[int]
    row_unique_key: str
    property_value: Any
    entity_key: str
    field_type: str


class APIAction(BaseModel):
    action_type: str
    request_type: str
    api: str


class MarkTaskCompleteRequest(BaseModel):
    task_id: str
    from_status: str
    to_status: str
    update_status: Optional[bool] = False
    update_key: Optional[str]
    update_value: Optional[str]


class SendNotification(BaseModel):
    task_id: str
    project_id: Optional[str]
    tz: str = "Asia/Kolkata"
    message: Optional[str] = ""


class CopyPropertyValues(BaseModel):
    task_id: str
    to_step_id: str
    property_dict: dict
    project_id: str
    submitted_data: dict
    periodic_date: Optional[str] = ""
