from typing import Optional, List

from pydantic.main import BaseModel


class EmailRequest(BaseModel):
    receiver_list: List[str]
    from_name: str
    content: str
    subject: str
    gateway_id: str = "default"
    template: Optional[str] = "default"
    link: Optional[str]


class ExternRequest(BaseModel):
    url: str
    timeout: Optional[int]
    cookies: Optional[dict]
    params: Optional[dict]
    auth: Optional[str]
