from typing import List, Optional, Dict

from pydantic import BaseModel


class SaveProdLoss(BaseModel):
    date: str
    step_id: str
    line: str
    equipment: str
    loss_category: str
    loss_reason: str
    loss_reason_comment: str
    loss_in_minutes: float

    class Config:
        orm_mode = True


class SaveTableRequest(BaseModel):
    replicate_type: str
    data_list: List
    step_id: str
    date: str
    project_id: Optional[str]
    cookies: Optional[Dict]
    tz: str = "Asia/Kolkata"


class CustomRestAPIRequest(BaseModel):
    submitted_data: Optional[Dict]
    stage_id: str
    project_id: str
    task_id: str
    tz: str
    date: int
