import traceback
from datetime import datetime

import pytz

from scripts.core.schemas.forms import CustomActionsModel
from scripts.db import User, mongo_client
from scripts.logging.logging import logger
from scripts.utils.mqtt_util import push_notification


class CustomAction:
    def __init__(self, custom_action: CustomActionsModel):
        self.custom_model: CustomActionsModel = custom_action
        self.user_conn = User(mongo_client)

    def trigger_action(self):
        notification = dict(
            type="ilens_assistant",
            message=f"{self.custom_model.action.get('message', '')}",
            notification_message="Notification Generated Successfully",
            notification_status="success",
            available_at=datetime.now().astimezone(
                pytz.timezone(self.custom_model.tz)).strftime("%d-%m-%Y %I:%M%p"),
            mark_as_read=False
        )
        try:
            user_data = self.user_conn.find_user_data_with_roles(self.custom_model.action.get("user_roles"),
                                                                 project_id=self.custom_model.project_id)
            for each in user_data:
                push_notification(notification, each.get("user_id"))
            return False, False
        except Exception as e:
            notification.update(type="ilens_assistant",
                                message="Notification failed to generate",
                                notification_message="Failed to send notification",
                                notification_status="failed")
            logger.error(f"Error while sending notification {e.args}")
            logger.error(traceback.format_exc())
