import time
from datetime import datetime

import pytz
import requests

from scripts.config.app_configurations import PathToServices
from scripts.constants.app_constants import CommonStatusCode
from scripts.core.schemas.forms import CustomActionsModel
from scripts.db import TaskInstance
from scripts.db import mongo_client
from scripts.logging.logging import logger
from scripts.utils.stage_parser import StageParser


class CustomAction:
    def __init__(self, custom_action: CustomActionsModel):
        self.custom_model: CustomActionsModel = custom_action
        self.task_inst_conn = TaskInstance(mongo_client, project_id=custom_action.project_id)
        self.stage_parser = StageParser(project_id=custom_action.project_id)

    def trigger_action(self):
        try:
            left_stages = self.stage_parser.get_stage_parser(self.custom_model.task_details.stages).get("left", [])

            self.custom_model.task_details.meta.update({"completed_at": int(time.time() * 1000)})

            task_meta = {"meta": self.custom_model.task_details.meta, "current_stage": left_stages[-1]}

            self.task_inst_conn.update_instance_task(task_id=self.custom_model.task_details.task_id, data=task_meta,
                                                     upsert=False)

            insert_json = {"task_completed_at": datetime.now(tz=pytz.timezone(self.custom_model.tz)).isoformat()}

            request_json = {"service_type": 'update', "data": {"task_id": self.custom_model.task_details.task_id,
                                                               "project_id": self.custom_model.project_id,
                                                               "data": insert_json}}

            try:
                api_url = f'{PathToServices.AUDIT_PROXY}/task/tracker'
                resp = requests.post(url=api_url, cookies=self.custom_model.request_obj.cookies,
                                     json=request_json)

                logger.debug(f"Resp Code:{resp.status_code}")
                if resp.status_code in CommonStatusCode.SUCCESS_CODES:
                    response = resp.json()
                    logger.debug(f"Response:{response}")
            except requests.exceptions.ConnectionError as e:
                logger.exception(e.args)
            return False, False
        except Exception as e:
            logger.error(f"Exception occurred in marking stage complete: {e}")
