from scripts.db import StepCollection, mongo_client, TaskInstanceData, TaskInstance
from scripts.utils.common_utils import CommonUtils


class StageParser:
    def __init__(self, project_id=None):
        self.stage_conn = StepCollection(mongo_client, project_id=project_id)
        self.common_utils = CommonUtils(project_id=project_id)
        self.step_conn = StepCollection(mongo_client, project_id=project_id)
        self.task_inst_data = TaskInstanceData(mongo_client, project_id=project_id)
        self.task_inst_conn = TaskInstance(mongo_client, project_id=project_id)

    def get_stage_parser(self, stages):
        stage_data, steps = self.task_inst_data.get_stage_map_steps(stages)
        step_data = self.step_conn.get_step_map(steps)
        left_nav = list()
        top_nav = list()
        for stage in stages:
            step = stage_data[stage]
            navigation = step_data[step]
            if navigation == "left_navigation":
                left_nav.append(stage)
            else:
                top_nav.append(stage)
        return dict(left=left_nav, right=top_nav)
