import traceback

from fastapi import APIRouter, Depends, Request

from scripts.constants.api import FormEndPoints
from scripts.core.schemas.mobile import GetMultiFormData
from scripts.core.schemas.response_models import DefaultMobileResponse, DefaultMobileFailureResponse
from scripts.logging.logging import logger
from scripts.mobility.handlers.task_handler import TaskHandlerMobile
from scripts.utils.security_utils.decorators import CookieAuthentication
from scripts.utils.security_utils.project_decorator import MetaInfoCookie, MetaInfoSchema

mobile_task_router = APIRouter(tags=["Form services"], prefix=FormEndPoints.api_mobile)
auth = CookieAuthentication()
get_cookies = MetaInfoCookie()


@mobile_task_router.post(FormEndPoints.api_mobile_form_multiple)
async def mobile_multi_form(request_data: GetMultiFormData, request_obj: Request,
                            meta: MetaInfoSchema = Depends(get_cookies)):
    try:
        task_handler_mobile = TaskHandlerMobile(project_id=request_data.project_id)
        response = await task_handler_mobile.multi_form_load(request_data, request_obj)
        return DefaultMobileResponse(status=True, message="success", data=response).dict()
    except Exception as e:
        tb = traceback.format_exc()
        logger.exception(e)
        logger.exception(tb)
        return DefaultMobileFailureResponse(error=e.args, message="Error encountered in rendering form")
