from fastapi import Request

from scripts.config.app_configurations import PathToServices
from scripts.constants.api import FormEndPoints
from scripts.core.handlers.form_handler import FormHandler
from scripts.core.handlers.stage_handler import StageHandler
from scripts.core.schemas.forms import SaveForm
from scripts.core.schemas.mobile import GetMultiFormData
from scripts.core.schemas.stages import StagesList
from scripts.db import TaskInstance, mongo_client
from scripts.logging.logging import logger
from scripts.utils.common_utils import CommonUtils


class TaskHandlerMobile:
    def __init__(self, project_id=None):
        self.comm_utils = CommonUtils(project_id=project_id)
        self.mobile_task_details_api = f"{PathToServices.WORKFLOW_MT}{FormEndPoints.api_wrk_task_details}"
        self.tasks_instance_conn = TaskInstance(mongo_client=mongo_client, project_id=project_id)
        self.stage_handler = StageHandler(project_id=project_id)
        self.form_handler = FormHandler(project_id=project_id)

    async def multi_form_load(self, request_data: GetMultiFormData, request_obj: Request):
        try:
            logger.debug(f"RESTAPI POST PAYLOAD: {request_data.dict()}")
            headers = {
                'login-token': request_obj.headers.get('login-token', request_obj.cookies.get('login-token')),
                'projectId': request_obj.cookies.get("projectId", request_obj.cookies.get("project_id",
                                                                                          request_obj.headers.get(
                                                                                              "projectId"))),
                'userId': request_obj.cookies.get("user_id",
                                                  request_obj.cookies.get("userId", request_obj.headers.get("userId")))}
            task_details = self.comm_utils.hit_external_service(api_url=self.mobile_task_details_api,
                                                                request_cookies=headers,
                                                                payload=request_data.dict())
            task_data = self.tasks_instance_conn.find_by_task_id(request_data.task_id)
            input_stage_list = dict(task_id=task_data.task_id, workflow_id=task_data.associated_workflow_id,
                                    task_status=task_data.current_status,
                                    workflow_version=task_data.associated_workflow_version,
                                    project_id=task_data.project_id, mobile=True)

            left_nav_data = self.stage_handler.get_stages_list(StagesList(**input_stage_list), nav_type='left',
                                                               user_id=request_data.user_id)

            task_info_data = {}
            for each in left_nav_data.get('stages'):
                if each.get('stage_id'):
                    form_input = dict(project_id=task_data.project_id, task_id=task_data.task_id,
                                      stage_id=each.get('stage_id'), triggers={})

                    each_form_data = await self.form_handler.form_renderer(SaveForm(**form_input), request_data.user_id,
                                                                           request_obj)

                    each.update(form_data=each_form_data[1])
            task_info_data |= task_details.get('data')
            task_info_data.update(dict(task_steps_data=left_nav_data))
            return task_info_data
        except Exception as e:
            logger.error(f"Exception while saving record {str(e)}")
            raise
